/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOError;
import java.io.IOException;
import java.security.AccessController;
import java.util.function.Supplier;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointBuilder;
import org.jboss.remoting3.RemotingXmlParser;
import org.wildfly.client.config.ConfigXMLParseException;

public final class ConfigurationEndpointSupplier
implements Supplier<Endpoint> {
    private static final Endpoint CONFIGURED_ENDPOINT = AccessController.doPrivileged(() -> {
        try {
            return RemotingXmlParser.parseEndpoint();
        }
        catch (IOException | ConfigXMLParseException e) {
            try {
                return new EndpointBuilder().build();
            }
            catch (IOException e1) {
                throw new IOError(e1);
            }
        }
    });

    @Override
    public Endpoint get() {
        return CONFIGURED_ENDPOINT;
    }
}

