/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.security.Permission;
import javax.net.ssl.SSLSession;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.security.RemotingPermission;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.PeerIdentity;
import org.wildfly.security.auth.client.PeerIdentityContext;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Result;

class ConnectionImpl
extends AbstractHandleableCloseable<Connection>
implements Connection {
    private final Attachments attachments = new Attachments();
    private final ConnectionHandler connectionHandler;
    private final Endpoint endpoint;
    private final URI peerUri;

    ConnectionImpl(EndpointImpl endpoint, ConnectionHandlerFactory connectionHandlerFactory, ConnectionProviderContext connectionProviderContext, URI peerUri) {
        super(endpoint.getExecutor(), true);
        this.endpoint = endpoint;
        this.peerUri = peerUri;
        EndpointImpl endpointImpl = endpoint;
        endpointImpl.getClass();
        this.connectionHandler = connectionHandlerFactory.createInstance(new EndpointImpl.LocalConnectionContext(endpointImpl, connectionProviderContext, this));
    }

    @Override
    protected void closeAction() throws IOException {
        this.connectionHandler.closeAsync();
        this.connectionHandler.addCloseHandler((closed, exception) -> this.closeComplete());
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.connectionHandler.getLocalAddress();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.connectionHandler.getPeerAddress();
    }

    ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    @Override
    public SSLSession getSslSession() {
        return this.connectionHandler.getSslSession();
    }

    @Override
    public IoFuture<Channel> openChannel(String serviceType, OptionMap optionMap) {
        FutureResult result = new FutureResult(this.getExecutor());
        result.addCancelHandler(this.connectionHandler.open(serviceType, (Result<Channel>)result, optionMap));
        return result.getIoFuture();
    }

    @Override
    public String getRemoteEndpointName() {
        return this.connectionHandler.getRemoteEndpointName();
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public URI getPeerURI() {
        return this.peerUri;
    }

    @Override
    public SecurityIdentity getLocalIdentity() {
        return this.connectionHandler.getLocalIdentity();
    }

    @Override
    public SecurityIdentity getLocalIdentity(int id) {
        return this.connectionHandler.getLocalIdentity(id);
    }

    @Override
    public int getPeerIdentityId() {
        return this.connectionHandler.getPeerIdentityId();
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    public String toString() {
        return String.format("Remoting connection <%x> on %s", this.hashCode(), this.endpoint);
    }

    @Override
    public PeerIdentity getConnectionPeerIdentity() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)RemotingPermission.GET_CONNECTION_PEER_IDENTITY));
        }
        throw Assert.unsupported();
    }

    @Override
    public PeerIdentity getConnectionAnonymousIdentity() {
        throw Assert.unsupported();
    }

    @Override
    public PeerIdentityContext getPeerIdentityContext() {
        throw Assert.unsupported();
    }
}

