/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Iterator;
import org.jboss.remoting3.remote.RemoteLogger;
import org.xnio.Buffers;
import org.xnio.ByteBufferPool;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.conduits.ConduitStreamSourceChannel;

final class MessageReader {
    private final ConduitStreamSourceChannel sourceChannel;
    private final ArrayDeque<ByteBuffer> queue = new ArrayDeque();
    private final Object lock;
    private final ByteBuffer[] array = new ByteBuffer[16];
    static final Pooled<ByteBuffer> EOF_MARKER = Buffers.emptyPooledByteBuffer();

    MessageReader(ConduitStreamSourceChannel sourceChannel, Object lock) {
        this.sourceChannel = sourceChannel;
        this.lock = lock;
    }

    ConduitStreamSourceChannel getSourceChannel() {
        return this.sourceChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    Pooled<ByteBuffer> getMessage() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            ByteBuffer[] b;
            block10: while (true) {
                long res;
                block40: {
                    block39: {
                        ByteBuffer first;
                        if ((first = this.queue.peekFirst()) != null) {
                            if (first.remaining() >= 4) {
                                int size = first.getInt(first.position());
                                if (this.remaining(size + 4)) {
                                    ByteBuffer message = ByteBufferPool.MEDIUM_HEAP.allocate();
                                    first.getInt();
                                    for (int cnt = 0; cnt < size; cnt += Buffers.copy((int)(size - cnt), (ByteBuffer)message, (ByteBuffer)first)) {
                                        if (first.hasRemaining()) continue;
                                        this.queue.pollFirst();
                                        first = this.queue.peekFirst();
                                    }
                                    message.flip();
                                    if (first != null && first.position() + 4 > first.limit()) {
                                        first.compact();
                                        first.flip();
                                    }
                                    RemoteLogger.conn.tracef("Received message %s", message);
                                    return Buffers.globalPooledWrapper((ByteBuffer)message);
                                }
                                if (RemoteLogger.conn.isTraceEnabled()) {
                                    RemoteLogger.conn.tracef("Not enough buffered bytes for message of size %d+4 (%s)", size, first);
                                }
                            } else if (this.queue.peekLast() == first) {
                                first.compact().flip();
                            } else {
                                first.compact();
                                try {
                                    Iterator<ByteBuffer> iterator = this.queue.iterator();
                                    iterator.next();
                                    assert (iterator.hasNext());
                                    do {
                                        ByteBuffer next;
                                        if ((next = iterator.next()).remaining() > 4) {
                                            first.putInt(next.getInt());
                                            continue;
                                        }
                                        Buffers.copy((ByteBuffer)first, (ByteBuffer)next);
                                    } while (first.position() < 4 && iterator.hasNext());
                                }
                                finally {
                                    first.flip();
                                }
                            }
                        } else {
                            RemoteLogger.conn.trace("No buffers in queue for message header");
                        }
                        b = this.array;
                        ByteBuffer last = this.queue.pollLast();
                        if (last != null) {
                            last.compact();
                            b[0] = last;
                            ByteBufferPool.MEDIUM_DIRECT.allocate(b, 1);
                            RemoteLogger.conn.tracef("Compacted existing buffer %s", last);
                        } else {
                            ByteBufferPool.MEDIUM_DIRECT.allocate(b, 0);
                            RemoteLogger.conn.tracef("Allocated fresh buffers", new Object[0]);
                        }
                        res = this.sourceChannel.read(b);
                        if (res != -1L) break block39;
                        RemoteLogger.conn.trace("Received EOF");
                        Pooled<ByteBuffer> pooled = EOF_MARKER;
                        for (int i = 0; i < b.length; ++i) {
                            ByteBuffer buffer = b[i];
                            if (buffer.position() > 0) {
                                buffer.flip();
                                this.queue.addLast(buffer);
                            } else {
                                ByteBufferPool.free((ByteBuffer)buffer);
                            }
                            b[i] = null;
                        }
                        return pooled;
                    }
                    if (res != 0L) break block40;
                    RemoteLogger.conn.trace("No read bytes available");
                    Pooled<ByteBuffer> pooled = null;
                    for (int i = 0; i < b.length; ++i) {
                        ByteBuffer buffer = b[i];
                        if (buffer.position() > 0) {
                            buffer.flip();
                            this.queue.addLast(buffer);
                        } else {
                            ByteBufferPool.free((ByteBuffer)buffer);
                        }
                        b[i] = null;
                    }
                    return pooled;
                }
                if (RemoteLogger.conn.isTraceEnabled()) {
                    RemoteLogger.conn.tracef("Received %d bytes", res);
                }
                int i = 0;
                while (true) {
                    if (i >= b.length) continue block10;
                    ByteBuffer buffer = b[i];
                    if (buffer.position() > 0) {
                        buffer.flip();
                        this.queue.addLast(buffer);
                    } else {
                        ByteBufferPool.free((ByteBuffer)buffer);
                    }
                    b[i] = null;
                    ++i;
                }
                break;
            }
            catch (Throwable throwable) {
                for (int i = 0; i < b.length; ++i) {
                    ByteBuffer buffer = b[i];
                    if (buffer.position() > 0) {
                        buffer.flip();
                        this.queue.addLast(buffer);
                    } else {
                        ByteBufferPool.free((ByteBuffer)buffer);
                    }
                    b[i] = null;
                }
                throw throwable;
            }
        }
    }

    private boolean remaining(int cnt) {
        int rem = 0;
        for (ByteBuffer buffer : this.queue) {
            if ((rem += buffer.remaining()) < cnt) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            ByteBuffer buffer;
            IoUtils.safeClose((Closeable)this.sourceChannel);
            while ((buffer = this.queue.pollFirst()) != null) {
                ByteBufferPool.free((ByteBuffer)buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadListener(ChannelListener<? super ConduitStreamSourceChannel> readListener) {
        Object object = this.lock;
        synchronized (object) {
            this.sourceChannel.setReadListener(readListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendReads() {
        Object object = this.lock;
        synchronized (object) {
            this.getSourceChannel().suspendReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeReads() {
        Object object = this.lock;
        synchronized (object) {
            this.getSourceChannel().resumeReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeupReads() {
        Object object = this.lock;
        synchronized (object) {
            this.getSourceChannel().wakeupReads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownReads() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.getSourceChannel().shutdownReads();
        }
    }
}

