/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.Version;
import org.jboss.remoting3.remote.MessageReader;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteAuthLogger;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.remote.RemoteReadListener;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.sasl.util.ProtocolSaslServerFactory;
import org.wildfly.security.sasl.util.ServerNameSaslServerFactory;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pooled;
import org.xnio.channels.Channels;
import org.xnio.channels.Configurable;
import org.xnio.channels.SslChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.sasl.SaslUtils;
import org.xnio.sasl.SaslWrapper;

final class ServerConnectionOpenListener
implements ChannelListener<ConduitStreamSourceChannel> {
    private final RemoteConnection connection;
    private final ConnectionProviderContext connectionProviderContext;
    private final SaslAuthenticationFactory saslAuthenticationFactory;
    private final OptionMap optionMap;
    private final AtomicInteger retryCount = new AtomicInteger(8);
    private final String serverName;

    ServerConnectionOpenListener(RemoteConnection connection, ConnectionProviderContext connectionProviderContext, SaslAuthenticationFactory saslAuthenticationFactory, OptionMap optionMap) {
        this.connection = connection;
        this.connectionProviderContext = connectionProviderContext;
        this.saslAuthenticationFactory = saslAuthenticationFactory;
        this.optionMap = optionMap;
        this.serverName = optionMap.contains(RemotingOptions.SERVER_NAME) ? (String)optionMap.get(RemotingOptions.SERVER_NAME) : connection.getLocalAddress().getHostName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ConduitStreamSourceChannel channel) {
        Pooled<ByteBuffer> pooled = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
            sendBuffer.put((byte)0);
            ProtocolUtils.writeString(sendBuffer, (byte)0, this.serverName);
            sendBuffer.flip();
            this.connection.setReadListener(new Initial(), true);
            this.connection.send(pooled);
            ok = true;
            return;
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            this.connection.handleException(RemoteLogger.log.invalidMessage(this.connection));
            return;
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    private void saslDispose(SaslServer saslServer) {
        if (saslServer != null) {
            try {
                saslServer.dispose();
            }
            catch (SaslException e) {
                RemoteLogger.server.trace("Failure disposing of SaslServer", e);
            }
        }
    }

    final class Authentication
    implements ChannelListener<ConduitStreamSourceChannel> {
        private final SaslServer saslServer;
        private final String remoteEndpointName;
        private final int behavior;
        private final int maxInboundChannels;
        private final int maxOutboundChannels;

        Authentication(SaslServer saslServer, String remoteEndpointName, int behavior, int maxInboundChannels, int maxOutboundChannels) {
            this.saslServer = saslServer;
            this.remoteEndpointName = remoteEndpointName;
            this.behavior = behavior;
            this.maxInboundChannels = maxInboundChannels;
            this.maxOutboundChannels = maxOutboundChannels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConduitStreamSourceChannel channel) {
            Pooled<ByteBuffer> message;
            try {
                message = ServerConnectionOpenListener.this.connection.getMessageReader().getMessage();
            }
            catch (IOException e) {
                ServerConnectionOpenListener.this.connection.handleException(e);
                ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                return;
            }
            if (message == MessageReader.EOF_MARKER) {
                RemoteLogger.log.trace("Received connection end-of-stream");
                ServerConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                return;
            }
            if (message == null) {
                return;
            }
            boolean free = true;
            try {
                ByteBuffer buffer = (ByteBuffer)message.getResource();
                RemoteLogger.server.tracef("Received %s", buffer);
                byte msgType = buffer.get();
                switch (msgType) {
                    case -1: {
                        RemoteLogger.server.trace("Server received connection close request");
                        ServerConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                        return;
                    }
                    case 4: {
                        RemoteLogger.server.tracef("Server received authentication response", new Object[0]);
                        ServerConnectionOpenListener.this.connection.getMessageReader().suspendReads();
                        ServerConnectionOpenListener.this.connection.getExecutor().execute(new AuthStepRunnable(false, this.saslServer, message, this.remoteEndpointName, this.behavior, this.maxInboundChannels, this.maxOutboundChannels));
                        free = false;
                        return;
                    }
                    case 1: {
                        RemoteLogger.server.trace("Server received capabilities request (cancelling authentication)");
                        ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                        Initial initial = new Initial();
                        ServerConnectionOpenListener.this.connection.setReadListener(initial, true);
                        initial.handleClientCapabilities(buffer);
                        initial.sendCapabilities();
                        return;
                    }
                }
                RemoteLogger.server.unknownProtocolId(msgType);
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                ServerConnectionOpenListener.this.saslDispose(this.saslServer);
            }
            catch (BufferOverflowException | BufferUnderflowException e) {
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                return;
            }
            finally {
                if (free) {
                    message.free();
                }
            }
        }
    }

    final class AuthStepRunnable
    implements Runnable {
        private final boolean isInitial;
        private final SaslServer saslServer;
        private final Pooled<ByteBuffer> buffer;
        private final String remoteEndpointName;
        private final int behavior;
        private final int maxInboundChannels;
        private final int maxOutboundChannels;

        AuthStepRunnable(boolean isInitial, SaslServer saslServer, Pooled<ByteBuffer> buffer, String remoteEndpointName, int behavior, int maxInboundChannels, int maxOutboundChannels) {
            this.isInitial = isInitial;
            this.saslServer = saslServer;
            this.buffer = buffer;
            this.remoteEndpointName = remoteEndpointName;
            this.behavior = behavior;
            this.maxInboundChannels = maxInboundChannels;
            this.maxOutboundChannels = maxOutboundChannels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean ok = false;
            boolean close = false;
            try {
                block14: {
                    Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
                    try {
                        ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                        int p = sendBuffer.position();
                        try {
                            sendBuffer.put((byte)5);
                            if (SaslUtils.evaluateResponse((SaslServer)this.saslServer, (ByteBuffer)sendBuffer, (ByteBuffer)((ByteBuffer)this.buffer.getResource()))) {
                                RemoteLogger.server.tracef("Server sending authentication complete", new Object[0]);
                                ServerConnectionOpenListener.this.connectionProviderContext.accept(connectionContext -> {
                                    Object qop = this.saslServer.getNegotiatedProperty("javax.security.sasl.qop");
                                    if (!this.isInitial && ("auth-int".equals(qop) || "auth-conf".equals(qop))) {
                                        ServerConnectionOpenListener.this.connection.setSaslWrapper(SaslWrapper.create((SaslServer)this.saslServer));
                                    }
                                    RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ServerConnectionOpenListener.this.connection, this.maxInboundChannels, this.maxOutboundChannels, this.remoteEndpointName, this.behavior);
                                    ServerConnectionOpenListener.this.connection.getRemoteConnectionProvider().addConnectionHandler(connectionHandler);
                                    SecurityIdentity identity = (SecurityIdentity)this.saslServer.getNegotiatedProperty("wildfly.sasl.security-identity");
                                    ServerConnectionOpenListener.this.connection.setIdentity(identity == null ? ServerConnectionOpenListener.this.saslAuthenticationFactory.getSecurityDomain().getAnonymousSecurityIdentity() : identity);
                                    ServerConnectionOpenListener.this.connection.setReadListener(new RemoteReadListener(connectionHandler, ServerConnectionOpenListener.this.connection), false);
                                    return connectionHandler;
                                });
                            } else {
                                RemoteLogger.server.tracef("Server sending authentication challenge", new Object[0]);
                                sendBuffer.put(p, (byte)3);
                                if (this.isInitial) {
                                    ServerConnectionOpenListener.this.connection.setReadListener(new Authentication(this.saslServer, this.remoteEndpointName, this.behavior, this.maxInboundChannels, this.maxOutboundChannels), false);
                                }
                            }
                        }
                        catch (Throwable e) {
                            RemoteLogger.server.tracef(e, "Server sending authentication rejected", new Object[0]);
                            sendBuffer.put(p, (byte)6);
                            ServerConnectionOpenListener.this.saslDispose(this.saslServer);
                            if (this.isInitial) {
                                if (ServerConnectionOpenListener.this.retryCount.decrementAndGet() <= 0) {
                                    close = true;
                                }
                            }
                            ServerConnectionOpenListener.this.connection.setReadListener(new Initial(), false);
                        }
                        sendBuffer.flip();
                        ServerConnectionOpenListener.this.connection.send(pooled, close);
                        ok = true;
                        ServerConnectionOpenListener.this.connection.getMessageReader().resumeReads();
                        if (ok) break block14;
                    }
                    catch (Throwable throwable) {
                        if (!ok) {
                            pooled.free();
                        }
                        throw throwable;
                    }
                    pooled.free();
                }
                return;
            }
            finally {
                this.buffer.free();
            }
        }
    }

    final class Initial
    implements ChannelListener<ConduitStreamSourceChannel> {
        private boolean starttls;
        private Set<String> allowedMechanisms;
        private int version = 1;
        private int channelsIn = 40;
        private int channelsOut = 40;
        private String remoteEndpointName;
        private int behavior = 2;

        Initial() {
        }

        void initialiseCapabilities() {
            SslChannel sslChannel = ServerConnectionOpenListener.this.connection.getSslChannel();
            boolean channelSecure = sslChannel != null && Channels.getOption((Configurable)sslChannel, (Option)Options.SECURE, (boolean)false);
            this.starttls = sslChannel != null && !channelSecure;
            LinkedHashSet<String> foundMechanisms = new LinkedHashSet<String>();
            boolean enableExternal = false;
            try {
                SSLSession sslSession;
                if (sslChannel != null && (sslSession = sslChannel.getSslSession()) != null) {
                    ServerConnectionOpenListener.this.connection.setIdentity((SecurityIdentity)sslSession.getValue("org.wildfly.security.ssl.identity"));
                    Principal principal = sslSession.getPeerPrincipal();
                    if (principal != null) {
                        enableExternal = true;
                    } else {
                        RemoteLogger.server.trace("No EXTERNAL mechanism due to lack of peer principal");
                    }
                } else {
                    RemoteLogger.server.trace("No EXTERNAL mechanism due to lack of SSL");
                }
            }
            catch (SSLPeerUnverifiedException e) {
                RemoteLogger.server.trace("No EXTERNAL mechanism due to unverified SSL peer");
            }
            for (String mechName : ServerConnectionOpenListener.this.saslAuthenticationFactory.getMechanismNames()) {
                if (foundMechanisms.contains(mechName)) {
                    RemoteLogger.server.tracef("Excluding repeated occurrence of mechanism %s", mechName);
                    continue;
                }
                if (!enableExternal && mechName.equals("EXTERNAL")) {
                    RemoteLogger.server.trace("Excluding EXTERNAL due to prior config");
                    continue;
                }
                RemoteLogger.server.tracef("Added mechanism %s", mechName);
                foundMechanisms.add(mechName);
            }
            this.allowedMechanisms = foundMechanisms;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleEvent(ConduitStreamSourceChannel channel) {
            SaslServer saslServer;
            ByteBuffer receiveBuffer;
            Pooled<ByteBuffer> message;
            try {
                message = ServerConnectionOpenListener.this.connection.getMessageReader().getMessage();
            }
            catch (IOException e) {
                ServerConnectionOpenListener.this.connection.handleException(e);
                return;
            }
            if (message == MessageReader.EOF_MARKER) {
                RemoteLogger.log.trace("Received connection end-of-stream");
                ServerConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                return;
            }
            if (message == null) {
                return;
            }
            boolean free = true;
            try {
                receiveBuffer = (ByteBuffer)message.getResource();
                RemoteLogger.server.tracef("Received %s", receiveBuffer);
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -1: {
                        RemoteLogger.server.trace("Server received connection close request");
                        ServerConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case -16: {
                        RemoteLogger.server.trace("Server received connection alive");
                        ServerConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.server.trace("Server received connection alive ack");
                        return;
                    }
                    case 1: {
                        RemoteLogger.server.trace("Server received capabilities request");
                        this.handleClientCapabilities(receiveBuffer);
                        this.sendCapabilities();
                        return;
                    }
                    case 7: {
                        RemoteLogger.server.tracef("Server received STARTTLS request", new Object[0]);
                        Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
                        boolean ok = false;
                        try {
                            ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                            sendBuffer.put(this.starttls ? (byte)7 : 8);
                            sendBuffer.flip();
                            ServerConnectionOpenListener.this.connection.send(pooled);
                            ok = true;
                            if (this.starttls) {
                                ServerConnectionOpenListener.this.connection.send(RemoteConnection.STARTTLS_SENTINEL);
                            }
                            ServerConnectionOpenListener.this.connection.setReadListener(new Initial(), true);
                            return;
                        }
                        finally {
                            if (!ok) {
                                pooled.free();
                            }
                        }
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        RemoteLogger.server.unknownProtocolId(msgType);
                        ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                        return;
                    }
                }
            }
            catch (BufferOverflowException | BufferUnderflowException e) {
                ServerConnectionOpenListener.this.connection.handleException(RemoteLogger.log.invalidMessage(ServerConnectionOpenListener.this.connection));
                return;
            }
            RemoteLogger.server.tracef("Server received authentication request", new Object[0]);
            if (ServerConnectionOpenListener.this.retryCount.decrementAndGet() < 1) {
                ServerConnectionOpenListener.this.connection.handleException(new SaslException("Too many authentication failures; connection terminated"), false);
                return;
            }
            String mechName = this.version < 1 ? Buffers.getModifiedUtf8((ByteBuffer)receiveBuffer) : ProtocolUtils.readString(receiveBuffer);
            String protocol = (String)ServerConnectionOpenListener.this.optionMap.get(RemotingOptions.SASL_PROTOCOL, (Object)"remote");
            try {
                saslServer = (SaslServer)ServerConnectionOpenListener.this.saslAuthenticationFactory.createMechanism(mechName, saslServerFactory -> new ProtocolSaslServerFactory((SaslServerFactory)new ServerNameSaslServerFactory(saslServerFactory, ServerConnectionOpenListener.this.serverName), protocol));
            }
            catch (SaslException e) {
                RemoteLogger.server.trace("Unable to create SaslServer", e);
                saslServer = null;
            }
            if (saslServer == null) {
                this.rejectAuthentication(mechName);
                return;
            }
            ServerConnectionOpenListener.this.connection.getMessageReader().suspendReads();
            ServerConnectionOpenListener.this.connection.getExecutor().execute(new AuthStepRunnable(true, saslServer, message, this.remoteEndpointName, this.behavior, this.channelsIn, this.channelsOut));
            return;
            finally {
                if (free) {
                    message.free();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rejectAuthentication(String mechName) {
            RemoteAuthLogger.authLog.rejectedInvalidMechanism(mechName);
            Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
            boolean ok = false;
            try {
                ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                sendBuffer.put((byte)6);
                sendBuffer.flip();
                ServerConnectionOpenListener.this.connection.send(pooled);
                ok = true;
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
        }

        void handleClientCapabilities(ByteBuffer receiveBuffer) {
            boolean useDefaultChannels = true;
            int channelsIn = 40;
            int channelsOut = 40;
            block8: while (receiveBuffer.hasRemaining()) {
                byte type = receiveBuffer.get();
                int len = receiveBuffer.get() & 0xFF;
                ByteBuffer data = Buffers.slice((ByteBuffer)receiveBuffer, (int)len);
                switch (type) {
                    case 0: {
                        byte version = data.get();
                        RemoteLogger.server.tracef("Server received capability: version %d", version & 0xFF);
                        this.version = Math.min(1, version & 0xFF);
                        continue block8;
                    }
                    case 3: {
                        this.remoteEndpointName = Buffers.getModifiedUtf8((ByteBuffer)data);
                        RemoteLogger.server.tracef("Server received capability: remote endpoint name \"%s\"", this.remoteEndpointName);
                        continue block8;
                    }
                    case 4: {
                        this.behavior |= 1;
                        this.behavior &= 0xFFFFFFFD;
                        RemoteLogger.server.tracef("Server received capability: message close protocol supported", new Object[0]);
                        continue block8;
                    }
                    case 5: {
                        this.behavior &= 0xFFFFFFFD;
                        String remoteVersionString = Buffers.getModifiedUtf8((ByteBuffer)data);
                        RemoteLogger.server.tracef("Server received capability: remote version is \"%s\"", remoteVersionString);
                        continue block8;
                    }
                    case 6: {
                        useDefaultChannels = false;
                        channelsOut = ProtocolUtils.readIntData(data, len);
                        RemoteLogger.server.tracef("Server received capability: remote channels in is \"%d\"", channelsOut);
                        continue block8;
                    }
                    case 7: {
                        useDefaultChannels = false;
                        channelsIn = ProtocolUtils.readIntData(data, len);
                        RemoteLogger.server.tracef("Server received capability: remote channels out is \"%d\"", channelsIn);
                        continue block8;
                    }
                }
                RemoteLogger.server.tracef("Server received unknown capability %02x", type & 0xFF);
            }
            if (!useDefaultChannels) {
                this.channelsIn = channelsIn;
                this.channelsOut = channelsOut;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendCapabilities() {
            if (this.allowedMechanisms == null) {
                this.initialiseCapabilities();
            }
            Pooled<ByteBuffer> pooled = ServerConnectionOpenListener.this.connection.allocate();
            boolean ok = false;
            try {
                ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                sendBuffer.put((byte)1);
                ProtocolUtils.writeByte(sendBuffer, 0, this.version);
                String localEndpointName = ServerConnectionOpenListener.this.connectionProviderContext.getEndpoint().getName();
                if (localEndpointName != null) {
                    ProtocolUtils.writeString(sendBuffer, (byte)3, localEndpointName);
                }
                if (this.starttls) {
                    ProtocolUtils.writeEmpty(sendBuffer, 2);
                }
                for (String mechName : this.allowedMechanisms) {
                    ProtocolUtils.writeString(sendBuffer, (byte)1, mechName);
                }
                ProtocolUtils.writeEmpty(sendBuffer, 4);
                ProtocolUtils.writeString(sendBuffer, (byte)5, Version.getVersionString());
                ProtocolUtils.writeInt(sendBuffer, 6, ServerConnectionOpenListener.this.optionMap.get(RemotingOptions.MAX_INBOUND_CHANNELS, 40));
                ProtocolUtils.writeInt(sendBuffer, 7, ServerConnectionOpenListener.this.optionMap.get(RemotingOptions.MAX_OUTBOUND_CHANNELS, 40));
                sendBuffer.flip();
                ServerConnectionOpenListener.this.connection.send(pooled);
                ok = true;
                return;
            }
            finally {
                if (!ok) {
                    pooled.free();
                }
            }
        }
    }
}

