/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.util.Collections;
import javax.xml.stream.XMLStreamReader;
import org.jboss.remoting3.ConnectionBuilder;
import org.jboss.remoting3.ConnectionProviderFactoryBuilder;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointBuilder;
import org.wildfly.client.config.ClientConfiguration;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.ConfigurationXMLStreamReader;
import org.wildfly.common.context.ContextManager;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.sasl.util.SaslFactories;

final class RemotingXmlParser {
    private static final String NS_REMOTING_5_0 = "urn:jboss-remoting:5.0";

    RemotingXmlParser() {
    }

    static Endpoint parseEndpoint() throws ConfigXMLParseException, IOException {
        ClientConfiguration clientConfiguration = ClientConfiguration.getInstance();
        EndpointBuilder builder = new EndpointBuilder();
        if (clientConfiguration != null) {
            try (ConfigurationXMLStreamReader streamReader = clientConfiguration.readConfiguration(Collections.singleton(NS_REMOTING_5_0));){
                RemotingXmlParser.parseDocument(streamReader, builder);
                Endpoint endpoint = builder.build();
                return endpoint;
            }
        }
        return null;
    }

    private static void parseDocument(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        if (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:jboss-remoting:5.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "endpoint": {
                            RemotingXmlParser.parseEndpointElement(reader, builder);
                            break block0;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                default: {
                    throw reader.unexpectedContent();
                }
            }
        }
    }

    private static void parseEndpointElement(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        block26: for (int i = 0; i < attributeCount; ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "name": {
                    builder.setEndpointName(reader.getAttributeValue(i));
                    continue block26;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        while (reader.hasNext()) {
            block6 : switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:jboss-remoting:5.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "providers": {
                            RemotingXmlParser.parseProvidersElement(reader, builder);
                            break block6;
                        }
                        case "connections": {
                            RemotingXmlParser.parseConnectionsElement(reader, builder);
                            break block6;
                        }
                        case "default-bind": {
                            builder.setDefaultBindAddress(RemotingXmlParser.parseBind(reader));
                            break block6;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                case 2: {
                    return;
                }
            }
        }
    }

    private static InetSocketAddress parseBind(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String address = null;
        int port = 0;
        block11: for (int i = 0; i < attributeCount; ++i) {
            switch (reader.getAttributeLocalName(i)) {
                case "address": {
                    address = reader.getAttributeValue(i);
                    continue block11;
                }
                case "port": {
                    port = reader.getIntAttributeValue(i);
                    if (port >= 0 && port <= 65535) continue block11;
                    throw new IllegalArgumentException("Port value out of range");
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (address == null) {
            throw reader.missingRequiredAttribute(null, "address");
        }
        InetSocketAddress bindAddress = InetSocketAddress.createUnresolved(address, port);
        switch (reader.nextTag()) {
            case 2: {
                return bindAddress;
            }
        }
        throw reader.unexpectedElement();
    }

    private static void parseProvidersElement(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:jboss-remoting:5.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "provider": {
                            RemotingXmlParser.parseProviderElement(reader, builder);
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                }
                case 2: {
                    return;
                }
            }
        }
    }

    private static void parseProviderElement(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String scheme = null;
        String[] aliases = null;
        String module = null;
        String clazz = null;
        block15: for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            switch (reader.getAttributeLocalName(i)) {
                case "scheme": {
                    scheme = reader.getAttributeValue(i);
                    continue block15;
                }
                case "aliases": {
                    aliases = reader.getListAttributeValueAsArray(i);
                    continue block15;
                }
                case "module": {
                    module = reader.getAttributeValue(i);
                    continue block15;
                }
                case "class": {
                    clazz = reader.getAttributeValue(i);
                    continue block15;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        ConnectionProviderFactoryBuilder providerBuilder = builder.addProvider(scheme);
        if (aliases != null) {
            for (void var11_13 : aliases) {
                providerBuilder.addAlias((String)var11_13);
            }
        }
        if (module == null && clazz == null) {
            throw new ConfigXMLParseException("At least one of the 'module' or 'class' attributes must be given", (XMLStreamReader)reader);
        }
        if (module != null) {
            providerBuilder.setModuleName(module);
        }
        if (clazz != null) {
            providerBuilder.setClassName(clazz);
        }
        switch (reader.nextTag()) {
            case 2: {
                return;
            }
        }
        throw reader.unexpectedElement();
    }

    private static void parseConnectionsElement(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:jboss-remoting:5.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "connection": {
                            RemotingXmlParser.parseConnectionElement(reader, builder);
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                }
                case 2: {
                    return;
                }
            }
        }
    }

    private static void parseConnectionElement(ConfigurationXMLStreamReader reader, EndpointBuilder builder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        URI uri = null;
        boolean immediate = false;
        block26: for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            switch (reader.getAttributeLocalName(i)) {
                case "uri": {
                    uri = reader.getURIAttributeValue(i);
                    continue block26;
                }
                case "immediate": {
                    immediate = reader.getBooleanAttributeValue(i);
                    continue block26;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (uri == null) {
            throw reader.missingRequiredAttribute("", "uri");
        }
        ConnectionBuilder connectionBuilder = builder.addConnection(uri);
        connectionBuilder.setImmediate(immediate);
        connectionBuilder.setSaslClientFactory(SaslFactories.getElytronSaslClientFactory());
        connectionBuilder.setAuthenticationContext(RemotingXmlParser.getGlobalDefaultAuthCtxt());
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 1: {
                    switch (reader.getNamespaceURI()) {
                        case "urn:jboss-remoting:5.0": {
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                    switch (reader.getLocalName()) {
                        case "bind": {
                            connectionBuilder.setBindAddress(RemotingXmlParser.parseBind(reader));
                            break;
                        }
                        case "abstract-type": {
                            RemotingXmlParser.parseAbstractType(reader, connectionBuilder);
                            break;
                        }
                        default: {
                            throw reader.unexpectedElement();
                        }
                    }
                }
                case 2: {
                    return;
                }
            }
        }
    }

    private static void parseAbstractType(ConfigurationXMLStreamReader reader, ConnectionBuilder connectionBuilder) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        String name = null;
        String authority = null;
        block8: for (int i = 0; i < attributeCount; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
                throw reader.unexpectedAttribute(i);
            }
            switch (reader.getAttributeLocalName(i)) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block8;
                }
                case "authority": {
                    authority = reader.getAttributeValue(i);
                    continue block8;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (name == null) {
            throw reader.missingRequiredAttribute(null, "name");
        }
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        if (authority != null) {
            connectionBuilder.setAbstractTypeAuthority(authority);
        }
        connectionBuilder.setAbstractType(name);
    }

    static AuthenticationContext getGlobalDefaultAuthCtxt() {
        return AccessController.doPrivileged(() -> ((ContextManager)AuthenticationContext.getContextManager()).getGlobalDefault());
    }
}

