/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.security.Permission;
import java.security.Principal;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionPeerIdentity;
import org.jboss.remoting3.ConnectionPeerIdentityContext;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.RejectingSaslServer;
import org.jboss.remoting3._private.IntIndexHashMap;
import org.jboss.remoting3._private.Messages;
import org.jboss.remoting3.security.RemotingPermission;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.sasl.SaslAuthenticationFactory;
import org.wildfly.security.sasl.util.ProtocolSaslServerFactory;
import org.wildfly.security.sasl.util.SSLSaslServerFactory;
import org.wildfly.security.sasl.util.ServerNameSaslServerFactory;
import org.wildfly.security.sasl.util.SocketAddressCallbackSaslServerFactory;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Result;

class ConnectionImpl
extends AbstractHandleableCloseable<Connection>
implements Connection {
    private final Attachments attachments = new Attachments();
    private final ConnectionHandler connectionHandler;
    private final EndpointImpl endpoint;
    private final URI peerUri;
    private final ConnectionPeerIdentityContext peerIdentityContext;
    private final IntIndexHashMap<Auth> authMap = new IntIndexHashMap<Auth>(Auth::getId);
    private final SaslAuthenticationFactory authenticationFactory;
    private final AuthenticationConfiguration authenticationConfiguration;
    private final String protocol;
    private final String saslProtocol;

    ConnectionImpl(EndpointImpl endpoint, ConnectionHandlerFactory connectionHandlerFactory, ConnectionProviderContext connectionProviderContext, URI peerUri, SaslAuthenticationFactory authenticationFactory, AuthenticationConfiguration authenticationConfiguration, String saslProtocol) {
        super(endpoint.getExecutor(), true);
        this.endpoint = endpoint;
        this.peerUri = peerUri;
        this.protocol = connectionProviderContext.getProtocol();
        this.authenticationConfiguration = authenticationConfiguration;
        this.saslProtocol = saslProtocol;
        EndpointImpl endpointImpl = endpoint;
        endpointImpl.getClass();
        this.connectionHandler = connectionHandlerFactory.createInstance(new EndpointImpl.LocalConnectionContext(endpointImpl, connectionProviderContext, this));
        this.authenticationFactory = authenticationFactory;
        this.peerIdentityContext = new ConnectionPeerIdentityContext(this, this.connectionHandler.getOfferedMechanisms(), this.getConnectionHandler().getPeerSaslServerName(), saslProtocol);
    }

    @Override
    protected void closeAction() throws IOException {
        this.connectionHandler.closeAsync();
        this.connectionHandler.addCloseHandler((closed, exception) -> this.closeComplete());
        for (Auth auth : this.authMap) {
            auth.dispose();
        }
        ConnectionPeerIdentityContext peerIdentityContext = this.peerIdentityContext;
        if (peerIdentityContext != null) {
            peerIdentityContext.connectionClosed();
        }
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.connectionHandler.getLocalAddress();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.connectionHandler.getPeerAddress();
    }

    AuthenticationConfiguration getAuthenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    @Override
    public SSLSession getSslSession() {
        return this.connectionHandler.getSslSession();
    }

    @Override
    public IoFuture<Channel> openChannel(String serviceType, OptionMap optionMap) {
        FutureResult result = new FutureResult(this.getExecutor());
        result.addCancelHandler(this.connectionHandler.open(serviceType, (Result<Channel>)result, optionMap));
        return result.getIoFuture();
    }

    @Override
    public String getRemoteEndpointName() {
        return this.connectionHandler.getRemoteEndpointName();
    }

    @Override
    public EndpointImpl getEndpoint() {
        return this.endpoint;
    }

    @Override
    public URI getPeerURI() {
        return this.peerUri;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public SecurityIdentity getLocalIdentity() {
        return this.connectionHandler.getLocalIdentity();
    }

    @Override
    public SecurityIdentity getLocalIdentity(int id) {
        if (id == 1) {
            SaslAuthenticationFactory authenticationFactory = this.authenticationFactory;
            return authenticationFactory == null ? null : authenticationFactory.getSecurityDomain().getAnonymousSecurityIdentity();
        }
        if (id == 0) {
            return this.getLocalIdentity();
        }
        Auth auth = this.authMap.get(id);
        return auth != null ? (SecurityIdentity)auth.getSaslServer().getNegotiatedProperty("wildfly.sasl.security-identity") : null;
    }

    @Override
    public int getPeerIdentityId() {
        return this.getPeerIdentityContext().getCurrentIdentity().getIndex();
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    public String toString() {
        return String.format("Remoting connection <%x> on %s", this.hashCode(), this.endpoint);
    }

    @Override
    public ConnectionPeerIdentity getConnectionPeerIdentity() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)RemotingPermission.GET_CONNECTION_PEER_IDENTITY));
        }
        return this.getPeerIdentityContext().getConnectionIdentity();
    }

    @Override
    public ConnectionPeerIdentity getConnectionAnonymousIdentity() {
        return this.getPeerIdentityContext().getAnonymousIdentity();
    }

    @Override
    public ConnectionPeerIdentityContext getPeerIdentityContext() {
        ConnectionPeerIdentityContext peerIdentityContext = this.peerIdentityContext;
        if (peerIdentityContext == null) {
            throw Assert.unsupported();
        }
        return peerIdentityContext;
    }

    @Override
    public boolean supportsRemoteAuth() {
        return this.connectionHandler.supportsRemoteAuth();
    }

    @Override
    public Principal getPrincipal() {
        return this.connectionHandler.getPrincipal();
    }

    public void receiveAuthRequest(int id, String mechName, byte[] initialResponse) {
        Messages.log.tracef("Received authentication request for ID %08x, mech %s", id, mechName);
        if (id == 0 || id == 1) {
            return;
        }
        this.getExecutor().execute(() -> {
            byte[] challenge;
            SaslServer saslServer;
            IntIndexHashMap<Auth> authMap = this.authMap;
            SSLSession sslSession = this.connectionHandler.getSslSession();
            try {
                saslServer = (SaslServer)this.authenticationFactory.createMechanism(mechName, f -> new ServerNameSaslServerFactory((SaslServerFactory)new ProtocolSaslServerFactory((SaslServerFactory)new SocketAddressCallbackSaslServerFactory((SaslServerFactory)(sslSession != null ? new SSLSaslServerFactory(f, this.connectionHandler::getSslSession) : f), this.getLocalAddress(), this.getPeerAddress()), this.saslProtocol), this.connectionHandler.getLocalSaslServerName()));
            }
            catch (SaslException e) {
                Messages.log.trace("Authentication failed at mechanism creation", e);
                try {
                    Auth oldAuth = authMap.put(new Auth(id, new RejectingSaslServer()));
                    if (oldAuth != null) {
                        oldAuth.dispose();
                    }
                    this.connectionHandler.sendAuthReject(id);
                }
                catch (IOException e1) {
                    Messages.log.trace("Failed to send auth reject", e1);
                }
                return;
            }
            Auth auth = new Auth(id, saslServer);
            Auth oldAuth = authMap.put(auth);
            if (oldAuth != null) {
                oldAuth.dispose();
            }
            try {
                challenge = saslServer.evaluateResponse(initialResponse);
            }
            catch (SaslException e) {
                Messages.log.trace("Authentication failed at response evaluation", e);
                try {
                    this.connectionHandler.sendAuthReject(id);
                }
                catch (IOException e1) {
                    authMap.remove(auth);
                    auth.dispose();
                    Messages.log.trace("Failed to send auth reject", e1);
                }
                return;
            }
            if (saslServer.isComplete()) {
                try {
                    this.connectionHandler.sendAuthSuccess(id, challenge);
                }
                catch (IOException e) {
                    authMap.remove(auth);
                    auth.dispose();
                    Messages.log.trace("Failed to send auth success", e);
                }
                return;
            }
            try {
                this.connectionHandler.sendAuthChallenge(id, challenge);
            }
            catch (IOException e) {
                authMap.remove(auth);
                auth.dispose();
                Messages.log.trace("Failed to send auth challenge", e);
            }
        });
    }

    void receiveAuthResponse(int id, byte[] response) {
        Messages.log.tracef("Received authentication response for ID %08x", id);
        if (id == 0 || id == 1) {
            return;
        }
        this.getExecutor().execute(() -> {
            byte[] challenge;
            Auth auth = this.authMap.get(id);
            if (auth == null && (auth = this.authMap.putIfAbsent(new Auth(id, new RejectingSaslServer()))) == null) {
                try {
                    this.connectionHandler.sendAuthReject(id);
                }
                catch (IOException e1) {
                    Messages.log.trace("Failed to send auth reject", e1);
                }
                return;
            }
            SaslServer saslServer = auth.getSaslServer();
            try {
                challenge = saslServer.evaluateResponse(response);
            }
            catch (SaslException e) {
                Messages.log.trace("Authentication failed at response evaluation", e);
                try {
                    this.connectionHandler.sendAuthReject(id);
                }
                catch (IOException e1) {
                    this.authMap.remove(auth);
                    auth.dispose();
                    Messages.log.trace("Failed to send auth reject", e1);
                }
                return;
            }
            if (saslServer.isComplete()) {
                try {
                    this.connectionHandler.sendAuthSuccess(id, challenge);
                }
                catch (IOException e) {
                    this.authMap.remove(auth);
                    auth.dispose();
                    Messages.log.trace("Failed to send auth success", e);
                }
                return;
            }
            try {
                this.connectionHandler.sendAuthChallenge(id, challenge);
            }
            catch (IOException e) {
                this.authMap.remove(auth);
                auth.dispose();
                Messages.log.trace("Failed to send auth challenge", e);
            }
        });
    }

    void receiveAuthDelete(int id) {
        Messages.log.tracef("Received authentication delete for ID %08x", id);
        if (id == 0 || id == 1) {
            return;
        }
        this.getExecutor().execute(() -> {
            Auth auth = this.authMap.removeKey(id);
            if (auth != null) {
                auth.dispose();
            }
            Messages.log.tracef("Deleted authentication ID %08x", id);
        });
    }

    static final class Auth {
        private final int id;
        private final SaslServer saslServer;

        Auth(int id, SaslServer saslServer) {
            this.id = id;
            this.saslServer = saslServer;
        }

        int getId() {
            return this.id;
        }

        SaslServer getSaslServer() {
            return this.saslServer;
        }

        void dispose() {
            try {
                this.saslServer.dispose();
            }
            catch (SaslException se) {
                Messages.log.trace("Failed to dispose SASL mechanism", se);
            }
        }
    }
}

