/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.remote.RemoteConnectionProvider;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.Result;
import org.xnio.XnioExecutor;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.SslChannel;
import org.xnio.sasl.SaslWrapper;

final class RemoteConnection {
    private static final String FQCN = RemoteConnection.class.getName();
    private final Pool<ByteBuffer> messageBufferPool;
    private final ConnectedMessageChannel channel;
    private final ConnectedStreamChannel underlyingChannel;
    private final OptionMap optionMap;
    private final RemoteWriteListener writeListener = new RemoteWriteListener();
    private final Executor executor;
    private final int heartbeatInterval;
    private volatile Result<ConnectionHandlerFactory> result;
    private volatile SaslWrapper saslWrapper;
    private final RemoteConnectionProvider remoteConnectionProvider;
    private final Runnable heartbeatCommand = new Runnable(){

        @Override
        public void run() {
            RemoteConnection.this.sendAlive();
        }
    };

    RemoteConnection(Pool<ByteBuffer> messageBufferPool, ConnectedStreamChannel underlyingChannel, ConnectedMessageChannel channel, OptionMap optionMap, RemoteConnectionProvider remoteConnectionProvider) {
        this.messageBufferPool = messageBufferPool;
        this.underlyingChannel = underlyingChannel;
        this.channel = channel;
        this.optionMap = optionMap;
        this.heartbeatInterval = optionMap.get(RemotingOptions.HEARTBEAT_INTERVAL, Integer.MAX_VALUE);
        RemoteLogger.conn.tracef("Initialized connection from %s to %s with options %s", underlyingChannel.getPeerAddress(), underlyingChannel.getLocalAddress(), optionMap);
        this.executor = remoteConnectionProvider.getExecutor();
        this.remoteConnectionProvider = remoteConnectionProvider;
    }

    Pooled<ByteBuffer> allocate() {
        return this.messageBufferPool.allocate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReadListener(ChannelListener<? super ConnectedMessageChannel> listener, boolean resume) {
        RemoteLogger.log.logf(RemoteConnection.class.getName(), Logger.Level.TRACE, null, "Setting read listener to %s", listener);
        Object object = this.getLock();
        synchronized (object) {
            this.channel.getReadSetter().set(listener);
            if (listener != null && resume) {
                this.channel.resumeReads();
            }
        }
    }

    RemoteConnectionProvider getRemoteConnectionProvider() {
        return this.remoteConnectionProvider;
    }

    Result<ConnectionHandlerFactory> getResult() {
        return this.result;
    }

    void setResult(Result<ConnectionHandlerFactory> result) {
        this.result = result;
    }

    void handleException(IOException e) {
        this.handleException(e, true);
    }

    void handleException(IOException e, boolean log) {
        XnioExecutor.Key key;
        RemoteLogger.conn.logf(RemoteConnection.class.getName(), Logger.Level.TRACE, e, "Connection error detail", new Object[0]);
        if (log) {
            RemoteLogger.conn.connectionError(e);
        }
        if ((key = this.writeListener.heartKey) != null) {
            key.remove();
        }
        IoUtils.safeClose((Closeable)this.channel);
        Result<ConnectionHandlerFactory> result = this.result;
        if (result != null) {
            result.setException(e);
            this.result = null;
        }
    }

    void send(Pooled<ByteBuffer> pooled) {
        this.writeListener.send(pooled, false);
    }

    void send(Pooled<ByteBuffer> pooled, boolean close) {
        this.writeListener.send(pooled, close);
    }

    void shutdownWrites() {
        this.writeListener.shutdownWrites();
    }

    OptionMap getOptionMap() {
        return this.optionMap;
    }

    ConnectedMessageChannel getChannel() {
        return this.channel;
    }

    ChannelListener<ConnectedMessageChannel> getWriteListener() {
        return this.writeListener;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public SslChannel getSslChannel() {
        return this.underlyingChannel instanceof SslChannel ? (SslChannel)this.underlyingChannel : null;
    }

    SaslWrapper getSaslWrapper() {
        return this.saslWrapper;
    }

    void setSaslWrapper(SaslWrapper saslWrapper) {
        this.saslWrapper = saslWrapper;
    }

    void handlePreAuthCloseRequest() {
        try {
            this.terminateHeartbeat();
            this.channel.close();
        }
        catch (IOException e) {
            RemoteLogger.conn.debug("Error closing remoting channel", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAlive() {
        RemoteLogger.conn.trace("Sending connection alive");
        Pooled<ByteBuffer> pooled = this.allocate();
        boolean ok = false;
        try {
            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
            buffer.put((byte)-16);
            buffer.limit(80);
            Buffers.addRandom((ByteBuffer)buffer);
            buffer.flip();
            this.send(pooled);
            ok = true;
            this.channel.wakeupReads();
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAliveResponse() {
        RemoteLogger.conn.trace("Sending connection alive ack");
        Pooled<ByteBuffer> pooled = this.allocate();
        boolean ok = false;
        try {
            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
            buffer.put((byte)-15);
            buffer.limit(80);
            Buffers.addRandom((ByteBuffer)buffer);
            buffer.flip();
            this.send(pooled);
            ok = true;
        }
        finally {
            if (!ok) {
                pooled.free();
            }
        }
    }

    void terminateHeartbeat() {
        XnioExecutor.Key key = this.writeListener.heartKey;
        if (key != null) {
            key.remove();
        }
    }

    Object getLock() {
        return this.writeListener.queue;
    }

    public String toString() {
        return String.format("Remoting connection %08x to %s", this.hashCode(), this.channel.getPeerAddress());
    }

    final class RemoteWriteListener
    implements ChannelListener<ConnectedMessageChannel> {
        private final Queue<Pooled<ByteBuffer>> queue = new ArrayDeque<Pooled<ByteBuffer>>();
        private XnioExecutor.Key heartKey;
        private boolean closed;

        RemoteWriteListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            Queue<Pooled<ByteBuffer>> queue = this.queue;
            synchronized (queue) {
                block11: {
                    assert (channel == RemoteConnection.this.getChannel());
                    Queue<Pooled<ByteBuffer>> queue2 = this.queue;
                    try {
                        Pooled<ByteBuffer> pooled;
                        while ((pooled = queue2.peek()) != null) {
                            ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                            if (channel.send(buffer)) {
                                RemoteLogger.conn.logf(FQCN, Logger.Level.TRACE, null, "Sent message %s (via queue)", buffer);
                                queue2.poll().free();
                                continue;
                            }
                            return;
                        }
                        if (!channel.flush()) break block11;
                        RemoteLogger.conn.logf(FQCN, Logger.Level.TRACE, null, "Flushed channel", new Object[0]);
                        if (this.closed) {
                            RemoteConnection.this.terminateHeartbeat();
                            channel.shutdownWrites();
                            if (channel.flush()) {
                                RemoteLogger.conn.logf(FQCN, Logger.Level.TRACE, null, "Shut down writes on channel", new Object[0]);
                                return;
                            }
                            return;
                        }
                        channel.suspendWrites();
                    }
                    catch (IOException e) {
                        Pooled<ByteBuffer> pooled;
                        RemoteConnection.this.handleException(e, false);
                        channel.wakeupReads();
                        while ((pooled = queue2.poll()) != null) {
                            pooled.free();
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownWrites() {
            Queue<Pooled<ByteBuffer>> queue = this.queue;
            synchronized (queue) {
                this.closed = true;
                RemoteConnection.this.terminateHeartbeat();
                ConnectedMessageChannel channel = RemoteConnection.this.getChannel();
                try {
                    if (!this.queue.isEmpty()) {
                        channel.resumeWrites();
                        return;
                    }
                    channel.shutdownWrites();
                    if (!channel.flush()) {
                        channel.resumeWrites();
                        return;
                    }
                    RemoteLogger.conn.logf(FQCN, Logger.Level.TRACE, null, "Shut down writes on channel", new Object[0]);
                }
                catch (IOException e) {
                    Pooled<ByteBuffer> unqueued;
                    RemoteConnection.this.handleException(e, false);
                    channel.wakeupReads();
                    while ((unqueued = this.queue.poll()) != null) {
                        unqueued.free();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void send(Pooled<ByteBuffer> pooled, boolean close) {
            Queue<Pooled<ByteBuffer>> queue = this.queue;
            // MONITORENTER : queue
            XnioExecutor.Key heartKey = this.heartKey;
            if (heartKey != null) {
                heartKey.remove();
            }
            if (this.closed) {
                pooled.free();
                // MONITOREXIT : queue
                return;
            }
            if (close) {
                this.closed = true;
            }
            ConnectedMessageChannel channel = RemoteConnection.this.getChannel();
            boolean free = true;
            try {
                ByteBuffer buffer;
                SaslWrapper wrapper = RemoteConnection.this.saslWrapper;
                if (wrapper != null) {
                    buffer = (ByteBuffer)pooled.getResource();
                    ByteBuffer source = buffer.duplicate();
                    buffer.clear();
                    wrapper.wrap(buffer, source);
                    buffer.flip();
                }
                if (this.queue.isEmpty()) {
                    buffer = (ByteBuffer)pooled.getResource();
                    if (!channel.send(buffer)) {
                        RemoteLogger.conn.logf(FQCN, Logger.Level.TRACE, null, "Can't directly send message %s, enqueued", buffer);
                        this.queue.add(pooled);
                        free = false;
                        channel.resumeWrites();
                        return;
                    }
                    RemoteLogger.conn.logf(FQCN, Logger.Level.TRACE, null, "Sent message %s (direct)", buffer);
                    if (close) {
                        channel.shutdownWrites();
                        RemoteLogger.conn.logf(FQCN, Logger.Level.TRACE, null, "Shut down writes on channel (direct)", new Object[0]);
                    }
                    if (!channel.flush()) {
                        channel.resumeWrites();
                        return;
                    }
                    RemoteLogger.conn.logf(FQCN, Logger.Level.TRACE, null, "Flushed channel (direct)", new Object[0]);
                    if (close) return;
                    this.heartKey = channel.getWriteThread().executeAfter(RemoteConnection.this.heartbeatCommand, (long)RemoteConnection.this.heartbeatInterval, TimeUnit.MILLISECONDS);
                    return;
                }
                this.queue.add(pooled);
                free = false;
                return;
            }
            catch (IOException e) {
                Pooled<ByteBuffer> unqueued;
                RemoteConnection.this.handleException(e, false);
                channel.wakeupReads();
                while ((unqueued = this.queue.poll()) != null) {
                    unqueued.free();
                }
                return;
            }
            finally {
                if (free) {
                    pooled.free();
                }
            }
        }
    }
}

