/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.utils.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.apache.maven.repository.internal.DefaultVersionRangeResolver;
import org.apache.maven.repository.internal.DefaultVersionResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.repository.internal.SnapshotMetadataGeneratorFactory;
import org.apache.maven.repository.internal.VersionsMetadataGeneratorFactory;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.ExclusionsDependencyFilter;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.jboss.logging.Logger;
import org.jboss.resteasy.utils.maven.ConsoleErrorHandler;
import org.jboss.resteasy.utils.maven.ConsoleRepositoryListener;
import org.jboss.resteasy.utils.maven.ConsoleTransferListener;

public class MavenUtil {
    protected static final Logger logger = Logger.getLogger((String)MavenUtil.class.getName());
    private static final String AETHER_API_NAME = File.separatorChar == '/' ? "/org/eclipse/aether/aether-api/" : "\\org\\eclipse\\aether\\aether-api\\";
    private final RepositorySystem REPOSITORY_SYSTEM;
    private final List<RemoteRepository> remoteRepositories;
    private static final String PROXY_HTTP_PREFIX = "http.";
    private static final String PROXY_HTTPS_PREFIX = "https.";
    private static final String PROXY_HOST = "proxyHost";
    private static final String PROXY_PORT = "proxyPort";
    private static String mavenRepository;

    private MavenUtil(RepositorySystem repositorySystem, List<RemoteRepository> remoteRepositories) {
        this.REPOSITORY_SYSTEM = repositorySystem;
        this.remoteRepositories = remoteRepositories;
    }

    public static MavenUtil create(boolean useEapRepository) {
        return new MavenUtil(MavenUtil.newRepositorySystem(), MavenUtil.createRemoteRepositories(useEapRepository));
    }

    public File createMavenGavFile(String artifactGav) throws MalformedURLException {
        DefaultArtifact artifact = new DefaultArtifact(artifactGav);
        if (artifact.getVersion() == null) {
            throw new IllegalArgumentException("Null version");
        }
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        try {
            versionScheme.parseVersion(artifact.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            versionScheme.parseVersionRange(artifact.getVersion());
            throw new IllegalArgumentException(artifact.getVersion() + " is a version range. A specific version is needed");
        }
        catch (InvalidVersionSpecificationException e) {
            ArtifactResult artifactResult;
            RepositorySystemSession session = this.newRepositorySystemSession();
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact((Artifact)artifact);
            for (RemoteRepository remoteRepo : this.remoteRepositories) {
                artifactRequest.addRepository(remoteRepo);
            }
            try {
                artifactResult = this.REPOSITORY_SYSTEM.resolveArtifact(session, artifactRequest);
            }
            catch (ArtifactResolutionException e2) {
                throw new RuntimeException(e2);
            }
            File file = artifactResult.getArtifact().getFile().getAbsoluteFile();
            return file;
        }
    }

    public List<File> createMavenGavRecursiveFiles(String artifactGav, String ... excludes) throws MalformedURLException, DependencyCollectionException, DependencyResolutionException {
        DefaultArtifact artifact = new DefaultArtifact(artifactGav);
        if (artifact.getVersion() == null) {
            throw new IllegalArgumentException("Null version");
        }
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        try {
            versionScheme.parseVersion(artifact.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            versionScheme.parseVersionRange(artifact.getVersion());
            throw new IllegalArgumentException(artifact.getVersion() + " is a version range. A specific version is needed");
        }
        catch (InvalidVersionSpecificationException e) {
            ArtifactResult artifactResult;
            RepositorySystemSession session = this.newRepositorySystemSession();
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact((Artifact)artifact);
            for (RemoteRepository remoteRepo : this.remoteRepositories) {
                artifactRequest.addRepository(remoteRepo);
            }
            try {
                artifactResult = this.REPOSITORY_SYSTEM.resolveArtifact(session, artifactRequest);
            }
            catch (ArtifactResolutionException e2) {
                throw new RuntimeException(e2);
            }
            ArrayList<File> urls = new ArrayList<File>();
            urls.add(artifactResult.getArtifact().getFile());
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new Dependency((Artifact)artifact, "compile"));
            for (RemoteRepository remoteRepo : this.remoteRepositories) {
                collectRequest.addRepository(remoteRepo);
            }
            DependencyNode node = this.REPOSITORY_SYSTEM.collectDependencies(session, collectRequest).getRoot();
            ExclusionsDependencyFilter filter = new ExclusionsDependencyFilter(Arrays.asList(excludes));
            DependencyRequest dependencyRequest = new DependencyRequest(node, (DependencyFilter)filter);
            this.REPOSITORY_SYSTEM.resolveDependencies(session, dependencyRequest);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            node.accept((DependencyVisitor)nlg);
            for (Artifact cur : nlg.getArtifacts(false)) {
                urls.add(cur.getFile());
            }
            logger.debug((Object)String.format("Class path for %s artifact of preorder node list generator is %s", artifactGav, nlg.getClassPath()));
            return urls;
        }
    }

    private static Integer getProxyPort(String systemProperty) {
        String port = System.getProperty(systemProperty);
        if (port != null && !port.isEmpty()) {
            try {
                Integer intPort = Integer.parseInt(port);
                return intPort;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    private static List<RemoteRepository> createRemoteRepositories(boolean useEapRepository) {
        RemoteRepository.Builder repository;
        String httpProxyHost = System.getProperty(String.format("%s%s", PROXY_HTTP_PREFIX, PROXY_HOST));
        String httpsProxyHost = System.getProperty(String.format("%s%s", PROXY_HTTPS_PREFIX, PROXY_HOST));
        Integer httpProxyPort = MavenUtil.getProxyPort(String.format("%s%s", PROXY_HTTP_PREFIX, PROXY_PORT));
        Integer httpsProxyPort = MavenUtil.getProxyPort(String.format("%s%s", PROXY_HTTPS_PREFIX, PROXY_PORT));
        Proxy httpProxy = null;
        Proxy httpsProxy = null;
        if (httpProxyHost != null && httpProxyPort != null && !httpProxyHost.isEmpty()) {
            httpProxy = new Proxy("http", httpProxyHost, httpProxyPort.intValue());
        }
        if (httpsProxyHost != null && httpsProxyPort != null && !httpsProxyHost.isEmpty()) {
            httpsProxy = new Proxy("https", httpsProxyHost, httpsProxyPort.intValue());
        }
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        if (useEapRepository) {
            repository = new RemoteRepository.Builder("product-repository", "default", "https://maven.repository.redhat.com/nexus/content/groups/product-techpreview/");
            if (httpsProxy != null) {
                repository.setProxy(httpsProxy);
            }
            remoteRepositories.add(repository.build());
        }
        repository = new RemoteRepository.Builder("jboss-developer", "default", "http://repository.jboss.org/nexus/content/groups/developer/");
        if (httpProxy != null) {
            repository.setProxy(httpProxy);
        }
        remoteRepositories.add(repository.build());
        RemoteRepository.Builder repository2 = new RemoteRepository.Builder("maven-default", "default", "https://repo.maven.apache.org/maven2/");
        if (httpProxy != null) {
            repository2.setProxy(httpProxy);
        }
        remoteRepositories.add(repository2.build());
        return remoteRepositories;
    }

    private RepositorySystemSession newRepositorySystemSession() {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(MavenUtil.determineLocalMavenRepositoryHack());
        session.setLocalRepositoryManager(this.REPOSITORY_SYSTEM.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setTransferListener((TransferListener)new ConsoleTransferListener());
        session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener());
        return session;
    }

    private static String determineLocalMavenRepositoryHack() {
        if (mavenRepository == null) {
            String localRepositoryRoot;
            String classPath = System.getProperty("java.class.path");
            int end = classPath.indexOf(AETHER_API_NAME) + 1;
            int start = classPath.lastIndexOf(File.pathSeparatorChar, end) + 1;
            mavenRepository = localRepositoryRoot = classPath.substring(start, end);
        }
        return mavenRepository;
    }

    public static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.addService(ArtifactDescriptorReader.class, DefaultArtifactDescriptorReader.class);
        locator.addService(VersionResolver.class, DefaultVersionResolver.class);
        locator.addService(VersionRangeResolver.class, DefaultVersionRangeResolver.class);
        locator.addService(MetadataGeneratorFactory.class, SnapshotMetadataGeneratorFactory.class);
        locator.addService(MetadataGeneratorFactory.class, VersionsMetadataGeneratorFactory.class);
        locator.setErrorHandler((DefaultServiceLocator.ErrorHandler)new ConsoleErrorHandler());
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }
}

