/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.utils.maven;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;
import org.jboss.logging.Logger;
import org.jboss.resteasy.utils.maven.ConsoleRepositoryListener;

class ConsoleTransferListener
extends AbstractTransferListener {
    protected static final Logger logger = Logger.getLogger((String)ConsoleRepositoryListener.class.getName());
    private Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();
    private int lastLength;

    ConsoleTransferListener() {
    }

    public void transferInitiated(TransferEvent event) {
        String message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        logger.debug((Object)(message + ": " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName()));
    }

    public void transferProgressed(TransferEvent event) {
        TransferResource resource = event.getResource();
        this.downloads.put(resource, event.getTransferredBytes());
        StringBuilder buffer = new StringBuilder(64);
        for (Map.Entry<TransferResource, Long> entry : this.downloads.entrySet()) {
            long total = entry.getKey().getContentLength();
            long complete = entry.getValue();
            buffer.append(this.getStatus(complete, total)).append("  ");
        }
        int pad = this.lastLength - buffer.length();
        this.lastLength = buffer.length();
        this.pad(buffer, pad);
        buffer.append('\r');
        logger.debug((Object)("Transfer progress: " + buffer.toString()));
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return this.toKB(complete) + "/" + this.toKB(total) + " KB ";
        }
        if (total >= 0L) {
            return complete + "/" + total + " B ";
        }
        if (complete >= 1024L) {
            return this.toKB(complete) + " KB ";
        }
        return complete + " B ";
    }

    private void pad(StringBuilder buffer, int spaces) {
        String block = "                                        ";
        while (spaces > 0) {
            int n = Math.min(spaces, block.length());
            buffer.append(block, 0, n);
            spaces -= n;
        }
    }

    public void transferSucceeded(TransferEvent event) {
        this.transferCompleted(event);
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        if (contentLength >= 0L) {
            String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
            String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
            String throughput = "";
            long duration = System.currentTimeMillis() - resource.getTransferStartTime();
            if (duration > 0L) {
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)contentLength / 1024.0 / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            logger.debug((Object)(type + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + throughput + ")"));
        }
    }

    public void transferFailed(TransferEvent event) {
        this.transferCompleted(event);
        logger.debug((Object)String.format("Transfer failed: %s", event.getException().toString()));
    }

    private void transferCompleted(TransferEvent event) {
        this.downloads.remove(event.getResource());
        StringBuilder buffer = new StringBuilder(64);
        this.pad(buffer, this.lastLength);
        buffer.append('\r');
        logger.debug((Object)("Transfer complete: " + buffer.toString()));
    }

    public void transferCorrupted(TransferEvent event) {
        logger.debug((Object)String.format("Corrupted download: %s", event.getException().toString()));
    }

    protected long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }
}

