/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.utils;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.resteasy.utils.TestManagementClient;
import org.junit.jupiter.api.Assertions;

public class ServerReload {
    public static final int TIMEOUT = 100000;
    private static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();

    public static void executeReload(ModelControllerClient client) {
        ServerReload.executeReload(client, Operations.createOperation((String)"reload"));
    }

    public static void executeReload(ModelControllerClient client, ModelNode reloadOp) {
        block3: {
            try {
                ModelNode result = client.execute(reloadOp);
                if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
                    Assertions.fail((String)Operations.getFailureDescription((ModelNode)result).asString());
                }
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ExecutionException || cause instanceof CancellationException) break block3;
                throw new RuntimeException(e);
            }
        }
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client) {
        ServerReload.executeReloadAndWaitForCompletion(client, 100000);
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, ModelNode reloadOp) {
        ServerReload.executeReloadAndWaitForCompletion(client, reloadOp, 100000);
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, int timeout) {
        ServerReload.executeReload(client);
        ModelControllerClientConfiguration config = client instanceof TestManagementClient ? ((TestManagementClient)client).getConfiguration() : TestManagementClient.createDefaultConfig();
        ServerReload.waitForLiveServerToReload(timeout, config);
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, ModelNode reloadOp, int timeout) {
        ServerReload.executeReload(client, reloadOp);
        ModelControllerClientConfiguration config = client instanceof TestManagementClient ? ((TestManagementClient)client).getConfiguration() : TestManagementClient.createDefaultConfig();
        ServerReload.waitForLiveServerToReload(timeout, config);
    }

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client, String serverConfig) {
        ModelNode op = Operations.createOperation((String)"reload");
        if (serverConfig != null) {
            op.get("server-config").set(serverConfig);
        }
        ServerReload.executeReloadAndWaitForCompletion(client, op);
    }

    public static String getContainerRunningState(ModelControllerClient client) throws IOException {
        ModelNode rsp = client.execute(Operations.createReadAttributeOperation((ModelNode)EMPTY_ADDRESS, (String)"server-state"));
        return Operations.isSuccessfulOutcome((ModelNode)rsp) ? Operations.readResult((ModelNode)rsp).asString() : "failed";
    }

    public static void reloadIfRequired(ModelControllerClient client) throws Exception {
        String runningState = ServerReload.getContainerRunningState(client);
        if ("reload-required".equalsIgnoreCase(runningState)) {
            ServerReload.executeReloadAndWaitForCompletion(client);
        } else {
            Assertions.assertEquals((Object)"running", (Object)runningState, (String)"Server state 'running' is expected");
        }
    }

    public static AutoCloseable takeSnapshot(int port) {
        AutoCloseable autoCloseable;
        block8: {
            TestManagementClient client = TestManagementClient.create("localhost", port);
            try {
                String fileName = ServerReload.takeSnapshot0((ModelControllerClient)client);
                autoCloseable = () -> {
                    try (TestManagementClient restoreClient = TestManagementClient.create("localhost", port);){
                        ServerReload.executeReloadAndWaitForCompletion((ModelControllerClient)restoreClient, fileName);
                        ModelNode result1 = restoreClient.execute(Operations.createOperation((String)"write-config"));
                        if (!Operations.isSuccessfulOutcome((ModelNode)result1)) {
                            Assertions.fail((String)("Failed to write config after restoring from snapshot " + Operations.getFailureDescription((ModelNode)result1).asString()));
                        }
                    }
                };
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to take snapshot", e);
                }
            }
            client.close();
        }
        return autoCloseable;
    }

    public static AutoCloseable takeSnapshot(ModelControllerClient client) {
        try {
            String fileName = ServerReload.takeSnapshot0(client);
            return () -> {
                ServerReload.executeReloadAndWaitForCompletion(client, fileName);
                ModelNode result1 = client.execute(Operations.createOperation((String)"write-config"));
                if (!Operations.isSuccessfulOutcome((ModelNode)result1)) {
                    Assertions.fail((String)("Failed to write config after restoring from snapshot " + Operations.getFailureDescription((ModelNode)result1).asString()));
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to take snapshot", e);
        }
    }

    private static String takeSnapshot0(ModelControllerClient client) throws IOException {
        String snapshot;
        ModelNode op = Operations.createOperation((String)"take-snapshot");
        ModelNode result = client.execute(op);
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            Assertions.fail((String)("Reload operation didn't finish successfully: " + Operations.getFailureDescription((ModelNode)result).asString()));
        }
        return (snapshot = Operations.readResult((ModelNode)result).asString()).contains(File.separator) ? snapshot.substring(snapshot.lastIndexOf(File.separator) + 1) : snapshot;
    }

    /*
     * Loose catch block
     */
    private static void waitForLiveServerToReload(int timeout, ModelControllerClientConfiguration config) {
        long start = System.currentTimeMillis();
        ModelNode operation = Operations.createReadAttributeOperation((ModelNode)EMPTY_ADDRESS, (String)"server-state");
        while (System.currentTimeMillis() - start < (long)timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                ModelControllerClient liveClient;
                block12: {
                    block13: {
                        liveClient = ModelControllerClient.Factory.create((ModelControllerClientConfiguration)config);
                        ModelNode result = liveClient.execute(operation);
                        if (!Operations.isSuccessfulOutcome((ModelNode)result) || !"running".equals(Operations.readResult((ModelNode)result).asString())) break block12;
                        if (liveClient == null) break block13;
                        liveClient.close();
                    }
                    return;
                }
                try {
                    continue;
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (liveClient == null) continue;
                    liveClient.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        Assertions.fail((String)"Live Server did not reload in the imparted time.");
    }
}

