/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.example.pubsub;

import java.util.LinkedList;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.example.pubsub.Subscriber;

public class Subscriber {
    protected int size;
    protected LinkedList<Entry> queue = new LinkedList();
    protected AsyncResponse response;

    public Subscriber(int size) {
        this.size = size;
    }

    public synchronized void post(MediaType type, byte[] content) {
        if (this.response == null) {
            if (this.queue.size() == this.size) {
                this.queue.removeFirst();
            }
            this.queue.addLast(new Entry(type, content));
            return;
        }
        this.response.resume((Object)Response.ok((Object)content, (MediaType)type).build());
        this.response = null;
    }

    public synchronized void poll(AsyncResponse response) {
        if (this.queue.size() == 0) {
            this.response = response;
            return;
        }
        Entry entry = (Entry)this.queue.removeFirst();
        response.resume((Object)Response.ok((Object)entry.content, (MediaType)entry.type).build());
    }
}

