package org.jboss.resteasy.grpc.protobuf;

import com.google.protobuf.Message;

/**
 * Given a protobuf descriptor file generated by {@link JavaToProtobufGenerator},
 * an implementation of {@code TranslateFromJavabuf} can translate a Java class generated
 * from the descriptor file by the protobuf compiler {@code protoc} back to its original
 * corresponding Java class.
 * <p/>
 * For example, let Java class {@code a.b.C} be transformed to protobuf message type
 * {@code a_b___C} by {@link JavaToProtobufGenerator}, which is then compiled by {@code protoc}
 * to a {@code com.google.protobuf.Message}, called, say (depending on configuration parameters),
 * {@code a.b.Outer_proto$a_b____C}. Then {@link JavabufTranslatorGenerator} can create
 * a class {@code Outer_JavabufTranslator} with an instance {@code a_b___CC_FromJavabuf}
 * of {@code TranslateFromJavabuf}, which can be used as follows:
 * <pre>
 *    a.b.Outer_proto$a_b____C c_proto = ...;
 *    C c = Outer_JavabufTranslator.translateFromJavabuf(c_proto); // Uses {@code a_b___CC_FromJavabuf}
 * </pre>
 */
public interface TranslateFromJavabuf {

   /**
    * Copies the contents of a {@code com.google.protobuf.Message} into a new instance of the target class.
    */
   Object assignFromJavabuf(Message message);

   /**
    * Copies the contents of a {@code com.google.protobuf.Message} into {@code obj}, an instance of the target class.
    */
   void assignExistingFromJavabuf(Message message, Object obj);
}
