package org.jboss.resteasy.grpc.protobuf;

import com.google.protobuf.Message;

/**
 * Given a protobuf descriptor file generated by {@link JavaToProtobufGenerator},
 * and a class generated from it by the compiler {@code protoc}, an implementation
 * of {@code TranslateToJavabuf} can translate the original Java class into an
 * instance of the compiled class.
 * <p/>
 * For example, let Java class {@code a.b.C} be transformed to protobuf message type
 * {@code a_b___C} by {@link JavaToProtobufGenerator}, which is then compiled by
 * {@code protoc} to a {@code com.google.protobuf.Message}, called, say (depending on
 * configuration parameters), {@code a.b.Outer_proto$a_b____C}. Then {@link JavabufTranslatorGenerator}
 * can create a class {@code Outer_JavabufTranslator} with an instance {@code a_b___CC_ToJavabuf}
 * of {@code TranslateToJavabuf}, which can be used as follows:
 * <pre>
 *    C c = new C();
 *    Message message = Outer_JavabufTranslator.translateToJavabuf(c);
 * </pre>
 */
public interface TranslateToJavabuf {

   /**
    * Copies the content of a Java class to a {@code com.google.protobuf.Message}
    */
   Message assignToJavabuf(Object obj);
}
