/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jwe.crypto;

import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.Arrays;
import org.jboss.resteasy.jose.jwe.crypto.AuthenticatedCipherText;
import org.jboss.resteasy.jose.jwe.crypto.CompositeKey;
import org.jboss.resteasy.jose.jwe.crypto.HMAC;

class AESCBC {
    public static final int IV_BIT_LENGTH = 128;

    public static byte[] generateIV(SecureRandom randomGen) {
        byte[] bytes = new byte[16];
        randomGen.nextBytes(bytes);
        return bytes;
    }

    private static Cipher createAESCBCCipher(SecretKey secretKey, boolean forEncryption, byte[] iv) throws RuntimeException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec keyspec = new SecretKeySpec(secretKey.getEncoded(), "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            if (forEncryption) {
                cipher.init(1, (Key)keyspec, ivSpec);
            } else {
                cipher.init(2, (Key)keyspec, ivSpec);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return cipher;
    }

    public static byte[] encrypt(SecretKey secretKey, byte[] iv, byte[] plainText) throws RuntimeException {
        Cipher cipher = AESCBC.createAESCBCCipher(secretKey, true, iv);
        try {
            return cipher.doFinal(plainText);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static byte[] computeAADLength(byte[] aad) {
        int bitLength = aad.length * 8;
        return ByteBuffer.allocate(8).putLong(bitLength).array();
    }

    public static AuthenticatedCipherText encryptAuthenticated(SecretKey secretKey, byte[] iv, byte[] plainText, byte[] aad) throws RuntimeException {
        CompositeKey compositeKey = new CompositeKey(secretKey);
        byte[] cipherText = AESCBC.encrypt(compositeKey.getAESKey(), iv, plainText);
        byte[] al = AESCBC.computeAADLength(aad);
        int hmacInputLength = aad.length + iv.length + cipherText.length + al.length;
        byte[] hmacInput = ByteBuffer.allocate(hmacInputLength).put(aad).put(iv).put(cipherText).put(al).array();
        byte[] hmac = HMAC.compute(compositeKey.getMACKey(), hmacInput);
        byte[] authTag = java.util.Arrays.copyOf(hmac, compositeKey.getTruncatedMACByteLength());
        return new AuthenticatedCipherText(cipherText, authTag);
    }

    public static byte[] decrypt(SecretKey secretKey, byte[] iv, byte[] cipherText) throws RuntimeException {
        Cipher cipher = AESCBC.createAESCBCCipher(secretKey, false, iv);
        try {
            return cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static byte[] decryptAuthenticated(SecretKey secretKey, byte[] iv, byte[] cipherText, byte[] aad, byte[] authTag) throws RuntimeException {
        CompositeKey compositeKey = new CompositeKey(secretKey);
        byte[] al = AESCBC.computeAADLength(aad);
        int hmacInputLength = aad.length + iv.length + cipherText.length + al.length;
        byte[] hmacInput = ByteBuffer.allocate(hmacInputLength).put(aad).put(iv).put(cipherText).put(al).array();
        byte[] hmac = HMAC.compute(compositeKey.getMACKey(), hmacInput);
        byte[] expectedAuthTag = java.util.Arrays.copyOf(hmac, compositeKey.getTruncatedMACByteLength());
        boolean macCheckPassed = true;
        if (!Arrays.constantTimeAreEqual((byte[])expectedAuthTag, (byte[])authTag)) {
            macCheckPassed = false;
        }
        byte[] plainText = AESCBC.decrypt(compositeKey.getAESKey(), iv, cipherText);
        if (!macCheckPassed) {
            throw new RuntimeException("MAC check failed");
        }
        return plainText;
    }

    private AESCBC() {
    }
}

