/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jose.jws;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.jose.jws.Algorithm;

public class JWSHeader
implements Serializable {
    @JsonProperty(value="alg")
    private Algorithm algorithm;
    @JsonProperty(value="typ")
    private String type;
    @JsonProperty(value="cty")
    private String contentType;
    private static final ObjectMapper mapper = new ObjectMapper();

    public JWSHeader() {
    }

    public JWSHeader(Algorithm algorithm, String type, String contentType) {
        this.algorithm = algorithm;
        this.type = type;
        this.contentType = contentType;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getType() {
        return this.type;
    }

    public String getContentType() {
        return this.contentType;
    }

    @JsonIgnore
    public MediaType getMediaType() {
        if (this.contentType == null) {
            return null;
        }
        return MediaType.valueOf((String)this.contentType);
    }

    public String toString() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

