/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.microprofile.config.ResteasyConfigSource;

public class ServletConfigSource
implements ResteasyConfigSource {
    private volatile String name;

    public Map<String, String> getProperties() {
        ServletConfig config = (ServletConfig)ResteasyContext.getContextData(ServletConfig.class);
        if (config == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration keys = config.getInitParameterNames();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                map.put(key, config.getInitParameter(key));
            }
        }
        return map;
    }

    public Set<String> getPropertyNames() {
        ServletConfig config = (ServletConfig)ResteasyContext.getContextData(ServletConfig.class);
        if (config == null) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Collections.list(config.getInitParameterNames()));
    }

    public String getValue(String propertyName) {
        ServletConfig config = (ServletConfig)ResteasyContext.getContextData(ServletConfig.class);
        if (config == null) {
            return null;
        }
        return config.getInitParameter(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        String currentName = this.name;
        if (currentName == null) {
            ServletConfigSource servletConfigSource = this;
            synchronized (servletConfigSource) {
                currentName = this.name;
                if (currentName == null) {
                    ServletContext servletContext = (ServletContext)ResteasyContext.getContextData(ServletContext.class);
                    ServletConfig servletConfig = (ServletConfig)ResteasyContext.getContextData(ServletConfig.class);
                    StringBuilder sb = new StringBuilder();
                    this.name = currentName = sb.append(servletContext != null ? servletContext.getServletContextName() : null).append(':').append(servletConfig != null ? servletConfig.getServletName() : null).append(":ServletConfigSource").toString();
                }
            }
        }
        return currentName;
    }

    @Override
    public int getDefaultOrdinal() {
        return 60;
    }
}

