/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.jboss.resteasy.cdi.CdiConstructorInjector;
import org.jboss.resteasy.cdi.CdiPropertyInjector;
import org.jboss.resteasy.cdi.ResteasyCdiExtension;
import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.Parameter;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.ResourceConstructor;
import org.jboss.resteasy.spi.metadata.ResourceLocator;

public class CdiInjectorFactory
implements InjectorFactory {
    private static final Logger log = Logger.getLogger(CdiInjectorFactory.class);
    public static final String BEAN_MANAGER_ATTRIBUTE_PREFIX = "org.jboss.weld.environment.servlet.";
    private BeanManager manager;
    private InjectorFactory delegate = new InjectorFactoryImpl();
    private ResteasyCdiExtension extension;
    private Map<Class<?>, Type> sessionBeanInterface;

    public CdiInjectorFactory() {
        this.manager = this.lookupBeanManager();
        this.extension = this.lookupResteasyCdiExtension();
        this.sessionBeanInterface = this.extension.getSessionBeanInterface();
    }

    public ValueInjector createParameterExtractor(Parameter parameter, ResteasyProviderFactory providerFactory) {
        return this.delegate.createParameterExtractor(parameter, providerFactory);
    }

    public MethodInjector createMethodInjector(ResourceLocator method, ResteasyProviderFactory factory) {
        return this.delegate.createMethodInjector(method, factory);
    }

    public PropertyInjector createPropertyInjector(ResourceClass resourceClass, ResteasyProviderFactory providerFactory) {
        return new CdiPropertyInjector(this.delegate.createPropertyInjector(resourceClass, providerFactory), resourceClass.getClazz(), this.sessionBeanInterface, this.manager);
    }

    public ConstructorInjector createConstructor(ResourceConstructor constructor, ResteasyProviderFactory providerFactory) {
        Class clazz = constructor.getConstructor().getDeclaringClass();
        ConstructorInjector injector = this.cdiConstructor(clazz);
        if (injector != null) {
            return injector;
        }
        log.debug("No CDI beans found for {0}. Using default ConstructorInjector.", new Object[]{clazz});
        return this.delegate.createConstructor(constructor, providerFactory);
    }

    public ConstructorInjector createConstructor(Constructor constructor, ResteasyProviderFactory factory) {
        Class clazz = constructor.getDeclaringClass();
        ConstructorInjector injector = this.cdiConstructor(clazz);
        if (injector != null) {
            return injector;
        }
        log.debug("No CDI beans found for {0}. Using default ConstructorInjector.", new Object[]{clazz});
        return this.delegate.createConstructor(constructor, factory);
    }

    protected ConstructorInjector cdiConstructor(Class<?> clazz) {
        if (!this.manager.getBeans(clazz, new Annotation[0]).isEmpty()) {
            log.debug("Using CdiConstructorInjector for class {0}.", new Object[]{clazz});
            return new CdiConstructorInjector(clazz, this.manager);
        }
        if (this.sessionBeanInterface.containsKey(clazz)) {
            Type intfc = this.sessionBeanInterface.get(clazz);
            log.debug("Using {0} for lookup of Session Bean {1}.", new Object[]{intfc, clazz});
            return new CdiConstructorInjector(intfc, this.manager);
        }
        return null;
    }

    public PropertyInjector createPropertyInjector(Class resourceClass, ResteasyProviderFactory factory) {
        return new CdiPropertyInjector(this.delegate.createPropertyInjector(resourceClass, factory), resourceClass, this.sessionBeanInterface, this.manager);
    }

    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, Class type, Type genericType, Annotation[] annotations, ResteasyProviderFactory factory) {
        return this.delegate.createParameterExtractor(injectTargetClass, injectTarget, type, genericType, annotations, factory);
    }

    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, Class type, Type genericType, Annotation[] annotations, boolean useDefault, ResteasyProviderFactory factory) {
        return this.delegate.createParameterExtractor(injectTargetClass, injectTarget, type, genericType, annotations, useDefault, factory);
    }

    protected BeanManager lookupBeanManager() {
        BeanManager beanManager = null;
        beanManager = this.lookupBeanManagerInJndi("java:comp/BeanManager");
        if (beanManager != null) {
            log.debug("Found BeanManager at java:comp/BeanManager");
            return beanManager;
        }
        beanManager = this.lookupBeanManagerInJndi("java:app/BeanManager");
        if (beanManager != null) {
            log.debug("Found BeanManager at java:app/BeanManager");
            return beanManager;
        }
        ServletContext servletContext = (ServletContext)ResteasyProviderFactory.getContextData(ServletContext.class);
        beanManager = (BeanManager)servletContext.getAttribute(BEAN_MANAGER_ATTRIBUTE_PREFIX + BeanManager.class.getName());
        if (beanManager != null) {
            log.debug("Found BeanManager in ServletContext");
            return beanManager;
        }
        beanManager = (BeanManager)servletContext.getAttribute(BeanManager.class.getName());
        if (beanManager != null) {
            log.debug("Found BeanManager in ServletContext");
            return beanManager;
        }
        throw new RuntimeException("Unable to lookup BeanManager.");
    }

    private BeanManager lookupBeanManagerInJndi(String name) {
        try {
            InitialContext ctx = new InitialContext();
            log.debug("Doing a lookup for BeanManager in {0}", new Object[]{name});
            return (BeanManager)ctx.lookup(name);
        }
        catch (NamingException e) {
            log.debug("Unable to obtain BeanManager from {0}", new Object[]{name});
            return null;
        }
        catch (NoClassDefFoundError ncdfe) {
            log.debug("Unable to perform JNDI lookups. You are probably running on GAE.");
            return null;
        }
    }

    private ResteasyCdiExtension lookupResteasyCdiExtension() {
        Set beans = this.manager.getBeans(ResteasyCdiExtension.class, new Annotation[0]);
        Bean bean = this.manager.resolve(beans);
        if (bean == null) {
            throw new IllegalStateException("Unable to obtain ResteasyCdiExtension instance.");
        }
        CreationalContext context = this.manager.createCreationalContext((Contextual)bean);
        return (ResteasyCdiExtension)this.manager.getReference(bean, ResteasyCdiExtension.class, context);
    }
}

