/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.header;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.resteasy.microprofile.client.header.ClientHeaderFillingException;
import org.jboss.resteasy.microprofile.client.header.HeaderFiller;
import org.jboss.resteasy.microprofile.client.header.HeaderUtils;

class DefaultHeaderFiller
implements HeaderFiller {
    private static final Logger LOGGER = Logger.getLogger(DefaultHeaderFiller.class);
    private final Method method;
    private final MethodHandle methodHandle;
    private final String headerName;
    private final boolean required;
    private final boolean withParam;

    DefaultHeaderFiller(String methodSpecifierString, String headerName, boolean required, Class<?> interfaceClass, Object clientProxy) {
        this.required = required;
        this.headerName = headerName;
        String methodSpecifier = methodSpecifierString.substring(1, methodSpecifierString.length() - 1);
        this.method = HeaderUtils.resolveMethod(methodSpecifier, interfaceClass, headerName);
        this.methodHandle = this.method.isDefault() ? HeaderUtils.createMethodHandle(this.method, clientProxy) : null;
        this.withParam = this.method.getParameterCount() == 1;
    }

    public List<String> generateValues() {
        try {
            Object result = this.methodHandle != null ? (this.withParam ? this.methodHandle.invokeWithArguments(this.headerName) : this.methodHandle.invokeWithArguments(new Object[0])) : (this.withParam ? this.method.invoke(null, this.headerName) : this.method.invoke(null, new Object[0]));
            if (result instanceof String[]) {
                return Arrays.asList((String[])result);
            }
            if (result instanceof List) {
                return HeaderUtils.castListToListOfStrings((List)result);
            }
            return Collections.singletonList(String.valueOf(result));
        }
        catch (Throwable e) {
            if (this.required) {
                throw new ClientHeaderFillingException("Failed to invoke header generation method: " + this.method, e);
            }
            LOGGER.warnv(e, "Invoking header generation method {0} failed", (Object)this.method.toString());
            return Collections.emptyList();
        }
    }
}

