/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines.vertx;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.streams.ReadStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.engines.AsyncClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.vertx.InputStreamAdapter;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.FinalizedClientResponse;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class VertxClientHttpEngine
implements AsyncClientHttpEngine {
    public static final String REQUEST_TIMEOUT_MS = Vertx.class + "$RequestTimeout";
    private final Vertx vertx;
    private final HttpClient httpClient;

    public VertxClientHttpEngine() {
        this.vertx = Vertx.vertx();
        this.httpClient = this.vertx.createHttpClient();
    }

    public VertxClientHttpEngine(Vertx vertx, HttpClientOptions options) {
        this.vertx = vertx;
        this.httpClient = vertx.createHttpClient(options);
    }

    public VertxClientHttpEngine(Vertx vertx) {
        this(vertx, new HttpClientOptions());
    }

    public VertxClientHttpEngine(HttpClient client) {
        this.vertx = null;
        this.httpClient = client;
    }

    public <T> Future<T> submit(ClientInvocation request, boolean buffered, InvocationCallback<T> callback, AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        CompletionStage future = this.submit(request).thenCompose(response -> {
            CompletableFuture tmp = new CompletableFuture();
            this.vertx.executeBlocking(promise -> {
                try {
                    Object result = extractor.extractResult(response);
                    tmp.complete(result);
                }
                catch (Exception e) {
                    tmp.completeExceptionally(e);
                }
            }, ar -> {});
            return tmp;
        });
        if (callback != null) {
            future = ((CompletableFuture)future).whenComplete((response, throwable) -> {
                if (throwable != null) {
                    callback.failed(throwable);
                } else {
                    callback.completed(response);
                }
            });
        }
        return future;
    }

    public <T> CompletableFuture<T> submit(ClientInvocation request, boolean buffered, AsyncClientHttpEngine.ResultExtractor<T> extractor, ExecutorService executorService) {
        return this.submit(request).thenCompose(response -> {
            CompletableFuture tmp = new CompletableFuture();
            executorService.execute(() -> {
                try {
                    Object result = extractor.extractResult(response);
                    tmp.complete(result);
                }
                catch (Exception e) {
                    tmp.completeExceptionally(e);
                }
            });
            return tmp;
        });
    }

    private CompletableFuture<ClientResponse> submit(ClientInvocation request) {
        long timeoutMs;
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod());
        Object entity = request.getEntity();
        Buffer body = entity != null ? Buffer.buffer((byte[])VertxClientHttpEngine.requestContent(request)) : null;
        RequestOptions options = new RequestOptions();
        options.setMethod(method);
        MultiMap headers = MultiMap.caseInsensitiveMultiMap();
        request.getHeaders().asMap().forEach((arg_0, arg_1) -> ((MultiMap)headers).add(arg_0, arg_1));
        options.setHeaders(headers);
        if (body != null) {
            headers.set(HttpHeaders.CONTENT_LENGTH, (CharSequence)("" + body.length()));
        }
        options.addHeader(HttpHeaders.USER_AGENT.toString(), "Vertx");
        URI uri = request.getUri();
        options.setHost(uri.getHost());
        if (-1 == uri.getPort()) {
            if ("http".equals(uri.getScheme())) {
                options.setPort(Integer.valueOf(80));
            } else if ("https".equals(uri.getScheme())) {
                options.setPort(Integer.valueOf(443));
            }
        } else {
            options.setPort(Integer.valueOf(uri.getPort()));
        }
        options.setURI(uri.getRawPath());
        Object timeout = request.getConfiguration().getProperty(REQUEST_TIMEOUT_MS);
        if (timeout != null && (timeoutMs = this.unwrapTimeout(timeout)) > 0L) {
            options.setTimeout(timeoutMs);
        }
        CompletableFuture<ClientResponse> futureResponse = new CompletableFuture<ClientResponse>();
        this.httpClient.request(options).map(httpClientRequest -> {
            Handler handler = event -> {
                if (event.succeeded()) {
                    HttpClientResponse response = (HttpClientResponse)event.result();
                    response.pause();
                    futureResponse.complete(this.toRestEasyResponse(request.getClientConfiguration(), response));
                    response.resume();
                } else {
                    futureResponse.completeExceptionally(event.cause());
                }
            };
            if (body != null) {
                httpClientRequest.send(body, handler);
            } else {
                httpClientRequest.send(handler);
            }
            return null;
        }).onFailure(futureResponse::completeExceptionally);
        return futureResponse;
    }

    private long unwrapTimeout(Object timeout) {
        if (timeout instanceof Duration) {
            return ((Duration)timeout).toMillis();
        }
        if (timeout instanceof Number) {
            return ((Number)timeout).longValue();
        }
        if (timeout != null) {
            return Long.parseLong(timeout.toString());
        }
        return -1L;
    }

    public SSLContext getSslContext() {
        throw new UnsupportedOperationException();
    }

    public HostnameVerifier getHostnameVerifier() {
        throw new UnsupportedOperationException();
    }

    public Response invoke(Invocation request) {
        CompletableFuture<ClientResponse> future = this.submit((ClientInvocation)request);
        try {
            return (Response)future.get();
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw VertxClientHttpEngine.clientException(e, null);
        }
        catch (ExecutionException e) {
            throw VertxClientHttpEngine.clientException(e.getCause(), null);
        }
    }

    public void close() {
        if (this.vertx != null) {
            this.vertx.close();
        } else {
            this.httpClient.close();
        }
    }

    static RuntimeException clientException(Throwable ex, Response clientResponse) {
        Object ret = ex == null ? new ProcessingException((Throwable)new NullPointerException()) : (ex instanceof WebApplicationException ? (WebApplicationException)ex : (ex instanceof ProcessingException ? (ProcessingException)ex : (clientResponse != null ? new ResponseProcessingException(clientResponse, ex) : new ProcessingException(ex))));
        return ret;
    }

    private static byte[] requestContent(ClientInvocation request) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        request.getDelegatingOutputStream().setDelegate((OutputStream)baos);
        try {
            request.writeRequestBody(request.getEntityStream());
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write the request body!", e);
        }
    }

    private ClientResponse toRestEasyResponse(ClientConfiguration clientConfiguration, HttpClientResponse clientResponse) {
        final InputStreamAdapter adapter = new InputStreamAdapter((ReadStream<Buffer>)clientResponse, 4096L);
        class RestEasyClientResponse
        extends FinalizedClientResponse {
            private InputStream is;

            RestEasyClientResponse(ClientConfiguration configuration) {
                super(configuration, RESTEasyTracingLogger.empty());
                this.is = adapter;
            }

            protected InputStream getInputStream() {
                return this.is;
            }

            protected void setInputStream(InputStream inputStream) {
                this.is = inputStream;
            }

            public void releaseConnection() throws IOException {
                this.releaseConnection(false);
            }

            public void releaseConnection(boolean consumeInputStream) throws IOException {
                try {
                    if (this.is != null) {
                        if (consumeInputStream) {
                            while (this.is.available() > 0) {
                                this.is.read();
                            }
                        }
                        this.is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        RestEasyClientResponse restEasyClientResponse = new RestEasyClientResponse(clientConfiguration);
        restEasyClientResponse.setStatus(clientResponse.statusCode());
        CaseInsensitiveMap restEasyHeaders = new CaseInsensitiveMap();
        clientResponse.headers().forEach(header -> restEasyHeaders.add((Object)((String)header.getKey()), (Object)((String)header.getValue())));
        restEasyClientResponse.setHeaders((MultivaluedMap)restEasyHeaders);
        return restEasyClientResponse;
    }
}

