/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.security.PublicKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.security.doseta.Verification;
import org.jboss.resteasy.security.doseta.VerificationResult;
import org.jboss.resteasy.security.doseta.VerificationResultSet;
import org.jboss.resteasy.security.doseta.VerificationResults;

public class Verifier {
    protected KeyRepository repository;
    protected List<Verification> verifications = new ArrayList<Verification>();

    public KeyRepository getRepository() {
        return this.repository;
    }

    public void setRepository(KeyRepository repository) {
        this.repository = repository;
    }

    public Verification addNew() {
        Verification verification = new Verification();
        this.verifications.add(verification);
        return verification;
    }

    public List<Verification> getVerifications() {
        return this.verifications;
    }

    public VerificationResults verify(List<DKIMSignature> signatures, Map headers, byte[] body) {
        VerificationResults results = new VerificationResults();
        results.setVerified(true);
        for (Verification verification : this.verifications) {
            VerificationResultSet resultSet = new VerificationResultSet();
            results.getResults().add(resultSet);
            resultSet.setVerification(verification);
            ArrayList<DKIMSignature> matched = new ArrayList<DKIMSignature>();
            matched.addAll(signatures);
            Iterator iterator = matched.iterator();
            while (iterator.hasNext()) {
                String value;
                DKIMSignature sig = (DKIMSignature)iterator.next();
                if (verification.getIdentifierName() == null || (value = sig.getAttributes().get(verification.getIdentifierName())) != null && value.equals(verification.getIdentifierValue())) continue;
                iterator.remove();
            }
            if (matched.isEmpty()) {
                results.setVerified(false);
                continue;
            }
            resultSet.setVerified(true);
            for (DKIMSignature signature : matched) {
                VerificationResult result = this.verify(headers, body, verification, signature);
                resultSet.getResults().add(result);
                if (result.isVerified()) continue;
                resultSet.setVerified(false);
                results.setVerified(false);
            }
        }
        return results;
    }

    public VerificationResult verify(Map headers, byte[] body, Verification verification, DKIMSignature signature) {
        VerificationResult result = new VerificationResult();
        result.setSignature(signature);
        try {
            this.verifySignature(headers, body, verification, signature);
        }
        catch (Exception e) {
            result.setFailureException(e);
            return result;
        }
        result.setVerified(true);
        return result;
    }

    public void verifySignature(Map headers, byte[] body, Verification verification, DKIMSignature signature) throws SignatureException {
        PublicKey key = verification.getKey();
        if (key == null) {
            if (verification.getRepository() != null) {
                key = verification.getRepository().findPublicKey(signature);
            } else if (this.repository != null) {
                key = this.repository.findPublicKey(signature);
            }
            if (key == null) {
                throw new SignatureException("Could not find PublicKey for DKIMSignature " + signature);
            }
        }
        signature.verify(headers, body, key);
        if (!verification.isIgnoreExpiration() && signature.isExpired()) {
            throw new SignatureException("Signature expired");
        }
        if (verification.isStaleCheck() && signature.isStale(verification.getStaleSeconds(), verification.getStaleMinutes(), verification.getStaleHours(), verification.getStaleDays(), verification.getStaleMonths(), verification.getStaleYears())) {
            throw new SignatureException("Signature is stale");
        }
    }
}

