/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb.json;

import java.io.IOException;
import java.io.Reader;
import org.jboss.resteasy.plugins.providers.jaxb.JAXBUnmarshalException;

public class JsonParsing {
    public static String extractJsonMapString(Reader reader) throws IOException {
        int openBrace = 1;
        boolean quote = false;
        boolean backslash = false;
        char c = (char)reader.read();
        StringBuffer buffer = new StringBuffer();
        if (c != '{') {
            throw new JAXBUnmarshalException("Expecting '{' in json map");
        }
        buffer.append(c);
        do {
            if ((c = (char)reader.read()) == '\uffffffff') {
                throw new JAXBUnmarshalException("Unexpected end of stream");
            }
            buffer.append(c);
            if (backslash) {
                backslash = false;
                continue;
            }
            switch (c) {
                case '\"': {
                    quote = !quote;
                    break;
                }
                case '{': {
                    if (quote) break;
                    ++openBrace;
                    break;
                }
                case '}': {
                    if (quote) break;
                    --openBrace;
                    break;
                }
                case '\\': {
                    backslash = true;
                }
            }
        } while (openBrace > 0 && c != '\uffffffff');
        return buffer.toString();
    }

    public static String getJsonString(Reader reader) throws IOException {
        boolean quote = true;
        boolean backslash = false;
        char c = (char)reader.read();
        StringBuffer buffer = new StringBuffer();
        if (c != '\"') {
            throw new JAXBUnmarshalException("Expecting '\"' in json map key");
        }
        do {
            if ((c = (char)reader.read()) == '\uffffffff') {
                throw new JAXBUnmarshalException("Unexpected end of stream");
            }
            if (backslash) {
                buffer.append(c);
                backslash = false;
                continue;
            }
            switch (c) {
                case '\"': {
                    quote = false;
                    break;
                }
                case '\\': {
                    backslash = true;
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
        } while (quote && c != '\uffffffff');
        return buffer.toString();
    }

    protected static char eatWhitspace(Reader buffer, boolean reset) throws IOException {
        char c;
        do {
            buffer.mark(2);
            c = (char)buffer.read();
            if (c != '\uffffffff') continue;
            new JAXBUnmarshalException("Unexpected end of json input");
        } while (Character.isWhitespace(c));
        if (reset) {
            buffer.reset();
        }
        return c;
    }
}

