/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jsapi;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.jsapi.MethodParamMetaData;
import org.jboss.resteasy.jsapi.ServiceRegistry;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.util.FindAnnotation;

public class MethodMetaData {
    private static final Logger logger = Logger.getLogger(MethodMetaData.class);
    private ResourceMethodInvoker resource;
    private Method method;
    private Class<?> klass;
    private String wants;
    private String consumesMIMEType;
    private String uri;
    private String functionName;
    private List<MethodParamMetaData> parameters = new ArrayList<MethodParamMetaData>();
    private Collection<String> httpMethods;
    private ServiceRegistry registry;
    private String functionPrefix;
    private boolean wantsForm;

    public MethodMetaData(ServiceRegistry serviceRegistry, ResourceMethodInvoker resource) {
        this.registry = serviceRegistry;
        this.resource = resource;
        this.method = resource.getMethod();
        this.klass = resource.getResourceClass();
        Path methodPath = this.method.getAnnotation(Path.class);
        Path klassPath = this.klass.getAnnotation(Path.class);
        Produces produces = this.method.getAnnotation(Produces.class);
        if (produces == null) {
            produces = this.klass.getAnnotation(Produces.class);
        }
        this.wants = this.getWants(produces);
        Consumes consumes = this.method.getAnnotation(Consumes.class);
        if (consumes == null) {
            consumes = this.klass.getAnnotation(Consumes.class);
        }
        this.uri = MethodMetaData.appendURIFragments(this.registry, klassPath, methodPath);
        this.functionPrefix = serviceRegistry.isRoot() ? this.klass.getSimpleName() : serviceRegistry.getFunctionPrefix();
        this.functionName = this.functionPrefix + "." + this.method.getName();
        this.httpMethods = resource.getHttpMethods();
        ArrayList<Method> methodsUntilRoot = new ArrayList<Method>();
        methodsUntilRoot.add(this.method);
        serviceRegistry.collectResourceMethodsUntilRoot(methodsUntilRoot);
        for (Method method : methodsUntilRoot) {
            Annotation[][] allAnnotations = method.getParameterAnnotations();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                this.processMetaData(parameterTypes[i], allAnnotations[i], true);
            }
        }
        this.consumesMIMEType = this.getConsumes(consumes);
        if (this.wantsForm && !"application/x-www-form-urlencoded".equals(this.consumesMIMEType)) {
            logger.warn("Overriding @Consumes annotation in favour of application/x-www-form-urlencoded due to the presence of @FormParam");
            this.consumesMIMEType = "application/x-www-form-urlencoded";
        }
    }

    protected void processMetaData(Class<?> type, Annotation[] annotations, boolean useBody) {
        QueryParam query = (QueryParam)FindAnnotation.findAnnotation((Annotation[])annotations, QueryParam.class);
        if (query != null) {
            this.addParameter(type, annotations, MethodParamMetaData.MethodParamType.QUERY_PARAMETER, query.value());
        } else {
            HeaderParam header = (HeaderParam)FindAnnotation.findAnnotation((Annotation[])annotations, HeaderParam.class);
            if (header != null) {
                this.addParameter(type, annotations, MethodParamMetaData.MethodParamType.HEADER_PARAMETER, header.value());
            } else {
                CookieParam cookie = (CookieParam)FindAnnotation.findAnnotation((Annotation[])annotations, CookieParam.class);
                if (cookie != null) {
                    this.addParameter(type, annotations, MethodParamMetaData.MethodParamType.COOKIE_PARAMETER, cookie.value());
                } else {
                    PathParam uriParam = (PathParam)FindAnnotation.findAnnotation((Annotation[])annotations, PathParam.class);
                    if (uriParam != null) {
                        this.addParameter(type, annotations, MethodParamMetaData.MethodParamType.PATH_PARAMETER, uriParam.value());
                    } else {
                        MatrixParam matrix = (MatrixParam)FindAnnotation.findAnnotation((Annotation[])annotations, MatrixParam.class);
                        if (matrix != null) {
                            this.addParameter(type, annotations, MethodParamMetaData.MethodParamType.MATRIX_PARAMETER, matrix.value());
                        } else {
                            FormParam formParam = (FormParam)FindAnnotation.findAnnotation((Annotation[])annotations, FormParam.class);
                            if (formParam != null) {
                                this.addParameter(type, annotations, MethodParamMetaData.MethodParamType.FORM_PARAMETER, formParam.value());
                                this.wantsForm = true;
                            } else {
                                Form form = (Form)FindAnnotation.findAnnotation((Annotation[])annotations, Form.class);
                                if (form != null) {
                                    if (type == Map.class || type == List.class) {
                                        this.addParameter(type, annotations, MethodParamMetaData.MethodParamType.FORM, form.prefix());
                                        this.wantsForm = true;
                                    } else {
                                        this.walkForm(type);
                                    }
                                } else if (FindAnnotation.findAnnotation((Annotation[])annotations, Context.class) == null && useBody) {
                                    this.addParameter(type, annotations, MethodParamMetaData.MethodParamType.ENTITY_PARAMETER, null);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void walkForm(Class<?> type) {
        for (Field field : type.getDeclaredFields()) {
            this.processMetaData(field.getType(), field.getAnnotations(), false);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            if (((Method)accessibleObject).getParameterTypes().length != 1 || !((Method)accessibleObject).getReturnType().equals(Void.class)) continue;
            this.processMetaData(((Method)accessibleObject).getParameterTypes()[0], accessibleObject.getAnnotations(), false);
        }
        if (type.getSuperclass() != null) {
            this.walkForm(type.getSuperclass());
        }
    }

    private void addParameter(Class<?> type, Annotation[] annotations, MethodParamMetaData.MethodParamType paramType, String value) {
        this.parameters.add(new MethodParamMetaData(type, annotations, paramType, value));
    }

    private String getWants(Produces produces) {
        if (produces == null) {
            return null;
        }
        String[] value = produces.value();
        if (value.length == 0) {
            return null;
        }
        if (value.length == 1) {
            return value[0];
        }
        StringBuffer buf = new StringBuffer();
        for (String mime : produces.value()) {
            if (buf.length() != 0) {
                buf.append(",");
            }
            buf.append(mime);
        }
        return buf.toString();
    }

    private String getConsumes(Consumes consumes) {
        if (consumes == null) {
            return "text/plain";
        }
        if (consumes.value().length > 0) {
            return consumes.value()[0];
        }
        return "text/plain";
    }

    public static String appendURIFragments(String ... fragments) {
        StringBuilder str = new StringBuilder();
        for (String fragment : fragments) {
            if (fragment == null || fragment.length() == 0 || fragment.equals("/")) continue;
            if (fragment.startsWith("/")) {
                fragment = fragment.substring(1);
            }
            if (fragment.endsWith("/")) {
                fragment = fragment.substring(0, fragment.length() - 1);
            }
            str.append('/').append(fragment);
        }
        if (str.length() == 0) {
            return "/";
        }
        return str.toString();
    }

    public ResourceMethodInvoker getResource() {
        return this.resource;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getKlass() {
        return this.klass;
    }

    public String getWants() {
        return this.wants;
    }

    public String getConsumesMIMEType() {
        return this.consumesMIMEType;
    }

    public String getUri() {
        return this.uri;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<MethodParamMetaData> getParameters() {
        return this.parameters;
    }

    public Collection<String> getHttpMethods() {
        return this.httpMethods;
    }

    public static String appendURIFragments(ServiceRegistry registry, Path classPath, Path methodPath) {
        return MethodMetaData.appendURIFragments(registry == null ? null : registry.getUri(), classPath != null ? classPath.value() : null, methodPath != null ? methodPath.value() : null);
    }

    public String getFunctionPrefix() {
        return this.functionPrefix;
    }
}

