/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.links;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.links.ELProvider;
import org.jboss.resteasy.links.LinkELProvider;
import org.jboss.resteasy.links.LinkResource;
import org.jboss.resteasy.links.ParamBinding;
import org.jboss.resteasy.links.RESTServiceDiscovery;
import org.jboss.resteasy.links.ResourceFacade;
import org.jboss.resteasy.links.i18n.LogMessages;
import org.jboss.resteasy.links.i18n.Messages;
import org.jboss.resteasy.links.impl.AbstractLinksProvider;
import org.jboss.resteasy.links.impl.BeanUtils;
import org.jboss.resteasy.links.impl.EL;
import org.jboss.resteasy.links.impl.ServiceDiscoveryException;
import org.jboss.resteasy.spi.ResteasyUriBuilder;

public class ObjectLinksProvider
extends AbstractLinksProvider<Object> {
    public ObjectLinksProvider(UriInfo uriInfo, ResourceMethodRegistry resourceMethodRegistry) {
        super(uriInfo, resourceMethodRegistry);
    }

    @Override
    public RESTServiceDiscovery getLinks(Object entity) {
        RESTServiceDiscovery restServiceDiscovery = new RESTServiceDiscovery();
        for (Method method : this.serviceMethods) {
            for (LinkResource linkResource : this.getLinkResources(method)) {
                this.processLinkResource(method, entity, restServiceDiscovery, linkResource);
            }
        }
        return restServiceDiscovery;
    }

    private void processLinkResource(Method m, Object entity, RESTServiceDiscovery ret, LinkResource service) {
        String rel = service.rel();
        Class<?> type = this.getServiceType(service, m);
        if (type.isInstance(entity)) {
            if (this.checkConstraint(service, entity, m)) {
                this.addInstanceService(m, entity, this.uriInfo, ret, service, rel);
            }
        } else if (entity instanceof ResourceFacade && ((ResourceFacade)entity).facadeFor() == type && this.checkConstraint(service, type, m)) {
            this.addCollectionService(m, (ResourceFacade)entity, this.uriInfo, ret, service, rel);
        }
    }

    private void addCollectionService(Method m, ResourceFacade<?> entity, UriInfo uriInfo, RESTServiceDiscovery ret, LinkResource service, String rel) {
        URI uri;
        List paramNames;
        Map<String, Object> pathParameters = entity.pathParameters();
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder().path(m.getDeclaringClass());
        if (m.isAnnotationPresent(Path.class)) {
            uriBuilder.path(m);
        }
        if ((paramNames = ((ResteasyUriBuilder)uriBuilder).getPathParamNamesInDeclarationOrder()).isEmpty()) {
            uri = uriBuilder.build(new Object[0]);
        } else if (pathParameters.size() >= paramNames.size()) {
            uri = uriBuilder.buildFromMap(pathParameters);
        } else {
            return;
        }
        if (rel.length() == 0) {
            if (m.isAnnotationPresent(GET.class)) {
                rel = "list";
            } else if (m.isAnnotationPresent(POST.class)) {
                rel = "add";
            }
        }
        ret.addLink(uri, rel);
    }

    private void addInstanceService(Method m, Object entity, UriInfo uriInfo, RESTServiceDiscovery ret, LinkResource service, String rel) {
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder().path(m.getDeclaringClass());
        if (m.isAnnotationPresent(Path.class)) {
            uriBuilder.path(m);
        }
        URI uri = this.buildURI(uriBuilder, service, entity, m);
        if (rel.length() == 0) {
            if (m.isAnnotationPresent(GET.class)) {
                Class<?> type = m.getReturnType();
                rel = Collection.class.isAssignableFrom(type) ? "list" : "self";
            } else if (m.isAnnotationPresent(PUT.class)) {
                rel = "update";
            } else if (m.isAnnotationPresent(POST.class)) {
                rel = "add";
            } else if (m.isAnnotationPresent(DELETE.class)) {
                rel = "remove";
            }
        }
        ret.addLink(uri, rel);
    }

    private URI buildURI(UriBuilder uriBuilder, LinkResource service, Object entity, Method m) {
        for (ParamBinding binding : service.queryParameters()) {
            uriBuilder.queryParam(binding.name(), new Object[]{this.evaluateEL(m, this.getELContext(m, entity), binding.value())});
        }
        for (ParamBinding binding : service.matrixParameters()) {
            uriBuilder.matrixParam(binding.name(), new Object[]{this.evaluateEL(m, this.getELContext(m, entity), binding.value())});
        }
        String[] uriTemplates = service.pathParameters();
        if (uriTemplates.length > 0) {
            Object[] values = new Object[uriTemplates.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.evaluateEL(m, this.getELContext(m, entity), uriTemplates[i]);
            }
            return uriBuilder.build(values);
        }
        List paramNames = ((ResteasyUriBuilder)uriBuilder).getPathParamNamesInDeclarationOrder();
        if (paramNames.isEmpty()) {
            return uriBuilder.build(new Object[0]);
        }
        List<Object> params = this.findURIParamsFromResource(entity);
        if (params.size() == paramNames.size()) {
            return uriBuilder.build(params.toArray());
        }
        if (params.size() > paramNames.size()) {
            return uriBuilder.build(params.subList(0, paramNames.size()).toArray());
        }
        throw new ServiceDiscoveryException(m, Messages.MESSAGES.notEnoughtUriParameters(paramNames.size(), params.size()));
    }

    private List<Object> findURIParamsFromResource(Object entity) {
        ArrayList<Object> ids = new ArrayList<Object>();
        do {
            List<Object> theseIDs = BeanUtils.findIDs(entity);
            ids.addAll(0, theseIDs);
        } while ((entity = BeanUtils.findParentResource(entity)) != null);
        return ids;
    }

    private boolean checkConstraint(LinkResource service, Object object, Method m) {
        String constraint = service.constraint();
        if (constraint == null || constraint.length() == 0) {
            return this.checkEJBConstraint(m);
        }
        Boolean ret = this.evaluateELBoolean(m, this.getELContext(m, object), constraint);
        return ret != null && ret != false;
    }

    private ELContext getELContext(Method m, Object base) {
        ELContext ours = EL.createELContext(base);
        ELProvider elProvider = this.getELProvider(m);
        if (elProvider != null) {
            return elProvider.getContext(ours);
        }
        return ours;
    }

    private ELProvider getELProvider(Method m) {
        LinkELProvider linkElProvider = this.findLinkELProvider(m);
        if (linkElProvider == null) {
            return null;
        }
        Class<? extends ELProvider> elProviderClass = linkElProvider.value();
        try {
            return elProviderClass.newInstance();
        }
        catch (Exception x) {
            LogMessages.LOGGER.error(Messages.MESSAGES.couldNotInstantiateELProviderClass(elProviderClass.getName()), x);
            throw new ServiceDiscoveryException(m, Messages.MESSAGES.failedToInstantiateELProvider(elProviderClass.getName()), x);
        }
    }

    private LinkELProvider findLinkELProvider(Method m) {
        if (m.isAnnotationPresent(LinkELProvider.class)) {
            return m.getAnnotation(LinkELProvider.class);
        }
        Class<?> c = m.getDeclaringClass();
        if (c.isAnnotationPresent(LinkELProvider.class)) {
            return c.getAnnotation(LinkELProvider.class);
        }
        Package p = c.getPackage();
        if (p != null && p.isAnnotationPresent(LinkELProvider.class)) {
            return p.getAnnotation(LinkELProvider.class);
        }
        return null;
    }

    public Object evaluateEL(Method m, ELContext context, String expression) {
        try {
            return EL.EXPRESSION_FACTORY.createValueExpression(context, expression, Object.class).getValue(context);
        }
        catch (Exception x) {
            throw new ServiceDiscoveryException(m, Messages.MESSAGES.failedToEvaluateELExpression(expression), x);
        }
    }

    public Boolean evaluateELBoolean(Method m, ELContext context, String expression) {
        try {
            return (Boolean)EL.EXPRESSION_FACTORY.createValueExpression(context, expression, Boolean.class).getValue(context);
        }
        catch (Exception x) {
            throw new ServiceDiscoveryException(m, Messages.MESSAGES.failedToEvaluateELExpression(expression), x);
        }
    }
}

