package org.jboss.resteasy.plugins.providers.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.CompletionStage;

import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;

import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;

/**
 * @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
 * @version $Revision: 1 $
 */
@Provider
@Produces("multipart/form-data")
public class MultipartFormDataWriter extends AbstractMultipartFormDataWriter
        implements AsyncMessageBodyWriter<MultipartFormDataOutput> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultipartFormDataOutput.class.isAssignableFrom(type);
    }

    public long getSize(MultipartFormDataOutput multipartFormDataOutput, Class<?> type, Type genericType,
            Annotation[] annotations, MediaType mediaType) {
        return -1;
    }

    public void writeTo(MultipartFormDataOutput multipartFormDataOutput, Class<?> type, Type genericType,
            Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders,
            OutputStream entityStream) throws IOException, WebApplicationException {
        write(multipartFormDataOutput, mediaType, httpHeaders, entityStream, annotations);
    }

    @Override
    public CompletionStage<Void> asyncWriteTo(MultipartFormDataOutput multipartFormDataOutput, Class<?> type, Type genericType,
            Annotation[] annotations,
            MediaType mediaType, MultivaluedMap<String, Object> httpHeaders,
            AsyncOutputStream entityStream) {
        return asyncWrite(multipartFormDataOutput, mediaType, httpHeaders, entityStream, annotations);
    }
}
