/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.auth.oauth;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import org.jboss.resteasy.auth.oauth.OAuthConsumer;
import org.jboss.resteasy.auth.oauth.OAuthException;
import org.jboss.resteasy.auth.oauth.OAuthProvider;
import org.jboss.resteasy.auth.oauth.OAuthRequestToken;
import org.jboss.resteasy.auth.oauth.OAuthToken;
import org.jboss.resteasy.auth.oauth.OAuthUtils;
import org.jboss.resteasy.auth.oauth.OAuthValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthServlet
extends HttpServlet {
    private static final long serialVersionUID = 3083924242786185155L;
    private static final Logger logger = LoggerFactory.getLogger(OAuthServlet.class);
    static final String PARAM_CONSUMER_REGISTRATION_URL = "oauth.provider.consumer.registration";
    static final String PARAM_REQUEST_TOKEN_URL = "oauth.provider.tokens.request";
    static final String PARAM_TOKEN_AUTHORIZATION_URL = "oauth.provider.tokens.authorization";
    static final String PARAM_ACCESS_TOKEN_URL = "oauth.provider.tokens.access";
    static final String PARAM_PROVIDER_CLASS = "oauth.provider.provider-class";
    static final String CONSUMER_SCOPES_REGISTRATION_URL = "/consumer-scopes";
    static final String TOKEN_AUTHORIZATION_CONFIRM_URL = "/authorization/confirm";
    private String requestTokenURL;
    private String accessTokenURL;
    private String consumerRegistrationURL;
    private String authorizationURL;
    private OAuthProvider provider;
    private OAuthValidator validator;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        logger.info("Loading OAuth Servlet");
        ServletContext context = config.getServletContext();
        this.consumerRegistrationURL = context.getInitParameter(PARAM_CONSUMER_REGISTRATION_URL);
        if (this.consumerRegistrationURL == null) {
            this.consumerRegistrationURL = "/registration";
        }
        this.authorizationURL = context.getInitParameter(PARAM_TOKEN_AUTHORIZATION_URL);
        if (this.authorizationURL == null) {
            this.authorizationURL = "/authorization";
        }
        this.requestTokenURL = context.getInitParameter(PARAM_REQUEST_TOKEN_URL);
        if (this.requestTokenURL == null) {
            this.requestTokenURL = "/requestToken";
        }
        this.accessTokenURL = context.getInitParameter(PARAM_ACCESS_TOKEN_URL);
        if (this.accessTokenURL == null) {
            this.accessTokenURL = "/accessToken";
        }
        logger.info("Request token URL: " + this.requestTokenURL);
        logger.info("Access token URL: " + this.accessTokenURL);
        this.provider = OAuthUtils.getOAuthProvider(context);
        this.validator = OAuthUtils.getValidator(context, this.provider);
        logger.debug("OAuthServlet loaded");
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        logger.debug("Serving " + pathInfo);
        logger.debug("Query " + req.getQueryString());
        if (pathInfo.equals(this.requestTokenURL)) {
            this.serveRequestToken(req, resp);
        } else if (pathInfo.equals(this.accessTokenURL)) {
            this.serveAccessToken(req, resp);
        } else if (pathInfo.equals(this.consumerRegistrationURL)) {
            this.serveConsumerRegistration(req, resp);
        } else if (pathInfo.equals(this.authorizationURL)) {
            this.serveTokenAuthorization(req, resp);
        } else if (pathInfo.startsWith(TOKEN_AUTHORIZATION_CONFIRM_URL)) {
            this.serveTokenAuthorizationConfirmation(req, resp);
        } else if (pathInfo.startsWith(CONSUMER_SCOPES_REGISTRATION_URL)) {
            this.serveConsumerScopesRegistrationRequest(req, resp);
        } else {
            resp.sendError(404);
        }
    }

    private void serveRequestToken(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug("Request token");
        OAuthMessage message = OAuthUtils.readMessage(req);
        try {
            message.requireParameters(new String[]{"oauth_consumer_key", "oauth_signature_method", "oauth_signature", "oauth_timestamp", "oauth_nonce"});
            logger.debug("Parameters present");
            String consumerKey = message.getParameter("oauth_consumer_key");
            OAuthConsumer consumer = this.provider.getConsumer(consumerKey);
            net.oauth.OAuthConsumer _consumer = new net.oauth.OAuthConsumer(null, consumerKey, consumer.getSecret(), null);
            OAuthAccessor accessor = new OAuthAccessor(_consumer);
            this.validator.validateMessage(message, accessor, null);
            String callbackURI = message.getParameter("oauth_callback");
            if (callbackURI != null && consumer.getConnectURI() != null && !callbackURI.startsWith(consumer.getConnectURI())) {
                throw new OAuthException(400, "Wrong callback URI");
            }
            OAuthToken token = this.provider.makeRequestToken(consumerKey, callbackURI, req.getParameterValues("xoauth_scope"));
            OAuthUtils.sendValues(resp, "oauth_token", token.getToken(), "oauth_token_secret", token.getSecret(), "oauth_callback_confirmed", "true");
            resp.setStatus(200);
            logger.debug("All OK");
        }
        catch (OAuthException x) {
            OAuthUtils.makeErrorResponse(resp, x.getMessage(), x.getHttpCode(), this.provider);
        }
        catch (OAuthProblemException x) {
            OAuthUtils.makeErrorResponse(resp, x.getProblem(), OAuthUtils.getHttpCode(x), this.provider);
        }
        catch (Exception x) {
            logger.error("Exception ", (Throwable)x);
            OAuthUtils.makeErrorResponse(resp, x.getMessage(), 500, this.provider);
        }
    }

    private void serveAccessToken(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug("Access token");
        OAuthMessage message = OAuthUtils.readMessage(req);
        try {
            message.requireParameters(new String[]{"oauth_consumer_key", "oauth_token", "oauth_signature_method", "oauth_signature", "oauth_timestamp", "oauth_nonce", "oauth_verifier"});
            logger.debug("Parameters present");
            String consumerKey = message.getParameter("oauth_consumer_key");
            String requestTokenString = message.getParameter("oauth_token");
            String verifier = message.getParameter("oauth_verifier");
            OAuthRequestToken requestToken = this.provider.getRequestToken(consumerKey, requestTokenString);
            net.oauth.OAuthConsumer consumer = new net.oauth.OAuthConsumer(null, consumerKey, requestToken.getConsumer().getSecret(), null);
            OAuthAccessor accessor = new OAuthAccessor(consumer);
            accessor.requestToken = requestTokenString;
            accessor.tokenSecret = requestToken.getSecret();
            this.validator.validateMessage(message, accessor, requestToken);
            OAuthToken tokens = this.provider.makeAccessToken(consumerKey, requestTokenString, verifier);
            OAuthUtils.sendValues(resp, "oauth_token", tokens.getToken(), "oauth_token_secret", tokens.getSecret());
            resp.setStatus(200);
            logger.debug("All OK");
        }
        catch (OAuthException x) {
            OAuthUtils.makeErrorResponse(resp, x.getMessage(), x.getHttpCode(), this.provider);
        }
        catch (OAuthProblemException x) {
            OAuthUtils.makeErrorResponse(resp, x.getProblem(), OAuthUtils.getHttpCode(x), this.provider);
        }
        catch (Exception x) {
            logger.error("Exception ", (Throwable)x);
            OAuthUtils.makeErrorResponse(resp, x.getMessage(), 500, this.provider);
        }
    }

    private void serveConsumerRegistration(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug("Consumer registration");
        try {
            String[] values = req.getParameterValues("oauth_consumer_key");
            if (values == null || values.length != 1) {
                resp.setStatus(400);
                return;
            }
            String consumerKey = URLDecoder.decode(values[0], "UTF-8");
            String displayName = null;
            values = req.getParameterValues("xoauth_consumer_display_name");
            if (values != null && values.length == 1) {
                displayName = URLDecoder.decode(values[0], "UTF-8");
            }
            String connectURI = null;
            values = req.getParameterValues("xoauth_consumer_connect_uri");
            if (values != null && values.length == 1) {
                connectURI = URLDecoder.decode(values[0], "UTF-8");
            }
            OAuthConsumer consumer = this.provider.registerConsumer(consumerKey, displayName, connectURI);
            OAuthUtils.sendValues(resp, "xoauth_consumer_secret", consumer.getSecret());
            resp.setStatus(200);
            logger.debug("All OK");
        }
        catch (Exception x) {
            logger.error("Exception ", (Throwable)x);
            OAuthUtils.makeErrorResponse(resp, x.getMessage(), 500, this.provider);
        }
    }

    private void serveConsumerScopesRegistrationRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug("Consumer registration");
        try {
            String[] values = req.getParameterValues("oauth_consumer_key");
            if (values == null || values.length != 1) {
                resp.setStatus(400);
                return;
            }
            String consumerKey = URLDecoder.decode(values[0], "UTF-8");
            OAuthConsumer consumer = this.provider.getConsumer(consumerKey);
            String[] scopes = req.getParameterValues("xoauth_scope");
            if (scopes != null) {
                consumer.setScopes(scopes);
            }
            resp.setStatus(200);
            logger.debug("All OK");
        }
        catch (Exception x) {
            logger.error("Exception ", (Throwable)x);
            OAuthUtils.makeErrorResponse(resp, x.getMessage(), 500, this.provider);
        }
    }

    private void serveTokenAuthorization(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug("Consumer token authorization request");
        try {
            String[] values = req.getParameterValues("oauth_token");
            if (values == null || values.length != 1) {
                resp.setStatus(400);
                return;
            }
            String requestTokenKey = values[0];
            OAuthRequestToken requestToken = this.provider.getRequestToken(null, requestTokenKey);
            OAuthConsumer consumer = requestToken.getConsumer();
            String acceptHeader = req.getHeader("Accept");
            String format = acceptHeader.startsWith("application/xml") ? "xml" : "html";
            this.requestEndUserConfirmation(req, resp, consumer, requestToken, format);
        }
        catch (Exception x) {
            logger.error("Exception ", (Throwable)x);
            OAuthUtils.makeErrorResponse(resp, x.getMessage(), 500, this.provider);
        }
    }

    private void requestEndUserConfirmation(HttpServletRequest req, HttpServletResponse resp, OAuthConsumer consumer, OAuthRequestToken requestToken, String format) {
        String uri = this.getAuthorizationConfirmURI(req, requestToken.getToken());
        StringBuilder sb = new StringBuilder();
        sb.append("<tokenAuthorizationRequest xmlns=\"http://org.jboss.com/resteasy/oauth\" ").append("replyTo=\"").append(uri).append("\">");
        sb.append("<consumerId>").append(consumer.getKey()).append("</consumerId>");
        if (consumer.getDisplayName() != null) {
            sb.append("<consumerName>").append(consumer.getKey()).append("</consumerName>");
        }
        if (requestToken.getScopes() != null) {
            sb.append("<requestScope>").append(requestToken.getScopes()[0]).append("</requestScope>");
        }
        sb.append("</tokenAuthorizationRequest>");
        try {
            resp.getWriter().append(sb.toString());
            resp.setStatus(200);
        }
        catch (IOException ex) {
            resp.setStatus(500);
        }
    }

    public String getAuthorizationConfirmURI(HttpServletRequest req, String tokenKey) {
        String requestURI = req.getRequestURL().toString();
        int index = requestURI.lastIndexOf(this.authorizationURL);
        String baseURI = requestURI.substring(0, index);
        return baseURI + TOKEN_AUTHORIZATION_CONFIRM_URL + "?" + "oauth_token" + "=" + OAuthUtils.encodeForOAuth(tokenKey);
    }

    private void serveTokenAuthorizationConfirmation(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug("Consumer registration");
        try {
            String[] values = req.getParameterValues("oauth_token");
            if (values == null || values.length != 1) {
                resp.setStatus(400);
                return;
            }
            String requestTokenKey = values[0];
            OAuthRequestToken requestToken = this.provider.getRequestToken(null, requestTokenKey);
            OAuthConsumer consumer = requestToken.getConsumer();
            values = req.getParameterValues("xoauth_end_user_decision");
            if (values == null || values.length != 1) {
                resp.setStatus(400);
                return;
            }
            boolean authorized = "yes".equals(values[0]);
            String callback = requestToken.getCallback();
            if (authorized) {
                String verifier = this.provider.authoriseRequestToken(consumer.getKey(), requestToken.getToken());
                if (callback == null) {
                    OAuthUtils.sendValues(resp, "oauth_token", requestTokenKey, "oauth_verifier", verifier);
                    resp.setStatus(200);
                } else {
                    ArrayList<OAuth.Parameter> parameters = new ArrayList<OAuth.Parameter>();
                    parameters.add(new OAuth.Parameter("oauth_token", requestTokenKey));
                    parameters.add(new OAuth.Parameter("oauth_verifier", verifier));
                    String location = OAuth.addParameters((String)callback, parameters);
                    resp.addHeader("Location", location);
                    resp.setStatus(303);
                }
            } else {
                OAuthUtils.makeErrorResponse(resp, "Token has not been authorized", 503, this.provider);
            }
            logger.debug("All OK");
        }
        catch (Exception x) {
            logger.error("Exception ", (Throwable)x);
            OAuthUtils.makeErrorResponse(resp, x.getMessage(), 500, this.provider);
        }
    }
}

