package org.jboss.resteasy.auth.oauth;

/**
 * Used to make sure the OAuthProvider implementer does not return null values.
 * If any null is returned, throws a RuntimeException
 * @author Stéphane Épardaud <stef@epardaud.fr>
 */
public class OAuthProviderChecker implements OAuthProvider {
	
	private OAuthProvider provider;

	public OAuthProviderChecker(OAuthProvider provider) {
		this.provider = provider;
	}

	private <T> T checkNull(T arg) {
		if(arg == null)
			throw new RuntimeException("OAuthProvider should not return null");
		return arg;
	}
	
	public OAuthConsumer registerConsumer(String consumerKey, String displayName, String connectURI) 
	    throws OAuthException {
        return checkNull(provider.registerConsumer(consumerKey, displayName, connectURI));
    }

	public OAuthConsumer getConsumer(String consumerKey) throws OAuthException {
		return checkNull(provider.getConsumer(consumerKey));
	}

	public String getRealm() {
		return checkNull(provider.getRealm());
	}

	public OAuthRequestToken getRequestToken(String consumerKey, String requestKey)
			throws OAuthException {
		return checkNull(provider.getRequestToken(consumerKey, requestKey));
	}

	public OAuthToken getAccessToken(String consumerKey, String accessKey)
	throws OAuthException {
		return checkNull(provider.getAccessToken(consumerKey, accessKey));
	}

	public void checkTimestamp(OAuthToken token, long timestamp) throws OAuthException {
		provider.checkTimestamp(token, timestamp);
	}

	public OAuthToken makeAccessToken(String consumerKey,
			String requestKey, String verifier) throws OAuthException {
		return checkNull(provider.makeAccessToken(consumerKey, requestKey, verifier));
	}

	public OAuthToken makeRequestToken(String consumerKey, String callback, 
	                                   String[] scopes, String[] permissions)
			throws OAuthException {
		return checkNull(provider.makeRequestToken(consumerKey, callback, scopes, permissions));
	}

	public String authoriseRequestToken(String consumerKey, String requestKey)
			throws OAuthException {
		return checkNull(provider.authoriseRequestToken(consumerKey, requestKey));
	}

    public void registerConsumerScopes(String consumerKey, String[] scopes)
            throws OAuthException {
        provider.registerConsumerScopes(consumerKey, scopes);
    }
    
    public void registerConsumerPermissions(String consumerKey, OAuthPermissions permissions)
        throws OAuthException {
        provider.registerConsumerPermissions(consumerKey, permissions);
    }
}
