/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.auth.oauth;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.resteasy.auth.oauth.OAuthConsumer;
import org.jboss.resteasy.auth.oauth.OAuthException;
import org.jboss.resteasy.auth.oauth.OAuthPermissions;
import org.jboss.resteasy.auth.oauth.OAuthProvider;
import org.jboss.resteasy.auth.oauth.OAuthRequestToken;
import org.jboss.resteasy.auth.oauth.OAuthToken;

public class OAuthMemoryProvider
implements OAuthProvider {
    private String realm;
    private ConcurrentHashMap<String, OAuthConsumer> consumers = new ConcurrentHashMap();
    private ConcurrentHashMap<String, OAuthRequestToken> requestTokens = new ConcurrentHashMap();
    private ConcurrentHashMap<String, OAuthToken> accessTokens = new ConcurrentHashMap();

    public OAuthMemoryProvider() {
        this("default");
    }

    public OAuthMemoryProvider(String realm) {
        this.realm = realm;
    }

    private OAuthToken doMakeAccessTokens(OAuthRequestToken requestToken) throws OAuthException {
        String newToken;
        while (this.accessTokens.containsKey(newToken = OAuthMemoryProvider.makeRandomString())) {
        }
        OAuthToken token = new OAuthToken(newToken, OAuthMemoryProvider.makeRandomString(), requestToken.getScopes(), requestToken.getPermissions(), -1L, requestToken.getConsumer());
        this.accessTokens.put(token.getToken(), token);
        return token;
    }

    private OAuthToken doGetAccessToken(String consumerKey, String accessKey) throws OAuthException {
        OAuthToken ret = this.accessTokens.get(accessKey);
        if (!ret.getConsumer().getKey().equals(consumerKey)) {
            throw new OAuthException(401, "Consumer is invalid");
        }
        if (ret == null) {
            throw new OAuthException(401, "No such access key " + accessKey);
        }
        return ret;
    }

    private OAuthRequestToken doMakeRequestToken(String consumerKey, String callback, String[] scopes, String[] permissions) throws OAuthException {
        String newToken;
        OAuthConsumer consumer = this._getConsumer(consumerKey);
        while (this.requestTokens.containsKey(newToken = OAuthMemoryProvider.makeRandomString())) {
        }
        OAuthRequestToken token = new OAuthRequestToken(newToken, OAuthMemoryProvider.makeRandomString(), callback, scopes, permissions, -1L, consumer);
        this.requestTokens.put(token.getToken(), token);
        return token;
    }

    private OAuthRequestToken doGetRequestToken(String customerKey, String requestKey) throws OAuthException {
        OAuthRequestToken ret = this.requestTokens.get(requestKey);
        this.checkCustomerKey(ret, customerKey);
        if (ret == null) {
            throw new OAuthException(401, "No such request key " + requestKey);
        }
        return ret;
    }

    public OAuthRequestToken verifyAndRemoveRequestToken(String customerKey, String requestToken, String verifier) throws OAuthException {
        OAuthRequestToken request = this.getRequestToken(requestToken);
        this.checkCustomerKey(request, customerKey);
        if (verifier == null || !verifier.equals(request.getVerifier())) {
            throw new OAuthException(401, "Invalid verifier code for token " + requestToken);
        }
        return this.requestTokens.remove(requestToken);
    }

    private static String makeRandomString() {
        return UUID.randomUUID().toString();
    }

    private void checkCustomerKey(OAuthToken token, String customerKey) throws OAuthException {
        if (customerKey != null && !customerKey.equals(token.getConsumer().getKey())) {
            throw new OAuthException(401, "Invalid customer key");
        }
    }

    protected void addConsumer(String consumerKey, String consumerSecret) {
        this.consumers.put(consumerKey, new OAuthConsumer(consumerKey, consumerSecret, null, null));
    }

    protected void addRequestKey(String consumerKey, String requestToken, String requestSecret, String callback, String[] scopes) throws OAuthException {
        OAuthConsumer consumer = this._getConsumer(consumerKey);
        OAuthRequestToken token = new OAuthRequestToken(requestToken, requestSecret, callback, scopes, null, -1L, consumer);
        this.requestTokens.put(requestToken, token);
    }

    protected void addAccessKey(String consumerKey, String accessToken, String accessSecret, String[] permissions) throws OAuthException {
        OAuthConsumer consumer = this._getConsumer(consumerKey);
        OAuthToken token = new OAuthToken(accessToken, accessSecret, null, permissions, -1L, consumer);
        this.accessTokens.put(accessToken, token);
    }

    protected void authoriseRequestToken(String consumerKey, String requestToken, String verifier) throws OAuthException {
        this.doGetRequestToken(consumerKey, requestToken).setVerifier(verifier);
    }

    protected OAuthConsumer _getConsumer(String consumerKey) throws OAuthException {
        OAuthConsumer ret = this.consumers.get(consumerKey);
        if (ret == null) {
            throw new OAuthException(401, "No such consumer key " + consumerKey);
        }
        return ret;
    }

    public String getRealm() {
        return this.realm;
    }

    public String authoriseRequestToken(String consumerKey, String requestToken) throws OAuthException {
        String verifier = OAuthMemoryProvider.makeRandomString();
        this.doGetRequestToken(consumerKey, requestToken).setVerifier(verifier);
        return verifier;
    }

    public OAuthConsumer registerConsumer(String consumerKey, String displayName, String connectURI) throws OAuthException {
        OAuthConsumer consumer = this.consumers.get(consumerKey);
        if (consumer == null) {
            return consumer;
        }
        consumer = new OAuthConsumer(consumerKey, "therealfrog", displayName, connectURI);
        this.consumers.putIfAbsent(consumerKey, consumer);
        return consumer;
    }

    public OAuthConsumer getConsumer(String consumerKey) throws OAuthException {
        return this._getConsumer(consumerKey);
    }

    public OAuthRequestToken getRequestToken(String consumerKey, String requestToken) throws OAuthException {
        OAuthRequestToken token = this.getRequestToken(requestToken);
        if (consumerKey != null && !token.getConsumer().getKey().equals(consumerKey)) {
            throw new OAuthException(401, "No such consumer key " + consumerKey);
        }
        return token;
    }

    public OAuthToken getAccessToken(String consumerKey, String accessToken) throws OAuthException {
        return this.doGetAccessToken(consumerKey, accessToken);
    }

    public void checkTimestamp(OAuthToken token, long timestamp) throws OAuthException {
        if (token.getTimestamp() > timestamp) {
            throw new OAuthException(401, "Invalid timestamp " + timestamp);
        }
    }

    public OAuthToken makeAccessToken(String consumerKey, String requestToken, String verifier) throws OAuthException {
        OAuthRequestToken token = this.verifyAndRemoveRequestToken(consumerKey, requestToken, verifier);
        return this.doMakeAccessTokens(token);
    }

    public OAuthRequestToken makeRequestToken(String consumerKey, String callback, String[] scopes, String[] permissions) throws OAuthException {
        OAuthRequestToken token = this.doMakeRequestToken(consumerKey, callback, scopes, permissions);
        this.requestTokens.put(token.getToken(), token);
        return token;
    }

    public OAuthRequestToken getRequestToken(String requestToken) throws OAuthException {
        OAuthRequestToken token = this.requestTokens.get(requestToken);
        if (token == null) {
            throw new OAuthException(401, "No such request token " + requestToken);
        }
        return token;
    }

    public void registerConsumerScopes(String consumerKey, String[] scopes) throws OAuthException {
        OAuthConsumer consumer = this._getConsumer(consumerKey);
        consumer.setScopes(scopes);
    }

    public void registerConsumerPermissions(String consumerKey, OAuthPermissions permissions) throws OAuthException {
    }
}

