/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.reactor.netty;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.jboss.resteasy.plugins.server.reactor.netty.ReactorNettyHttpResponse;
import org.jboss.resteasy.plugins.server.reactor.netty.SinkSubscriber;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.netty.http.server.HttpServerResponse;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

class ChunkOutputStream
extends AsyncOutputStream {
    private static final Sinks.EmitFailureHandler EMIT_FAILURE_HANDLER = Sinks.EmitFailureHandler.FAIL_FAST;
    private final ReactorNettyHttpResponse parentResponse;
    private final Sinks.Empty<Void> completionSink;
    private volatile boolean started;
    private Sinks.Many<Tuple2<byte[], CompletableFuture<Void>>> byteSink;
    private final Supplier<Sinks.Many<Tuple2<byte[], CompletableFuture<Void>>>> byteSinkSupplier;

    ChunkOutputStream(ReactorNettyHttpResponse parentResponse, HttpServerResponse reactorNettyResponse, Sinks.Empty<Void> completionSink) {
        this.parentResponse = Objects.requireNonNull(parentResponse);
        this.completionSink = Objects.requireNonNull(completionSink);
        Objects.requireNonNull(reactorNettyResponse);
        this.byteSinkSupplier = () -> {
            Sinks.Many outSink = Sinks.many().multicast().onBackpressureBuffer();
            Flux byteFlux = outSink.asFlux().map(tup -> {
                ((CompletableFuture)tup.getT2()).complete(null);
                return (byte[])tup.getT1();
            });
            SinkSubscriber.subscribe(completionSink, (Mono<Void>)Mono.from((Publisher)reactorNettyResponse.sendByteArray((Publisher)byteFlux)));
            return outSink;
        };
    }

    public void write(int b) {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void close() throws IOException {
        if (!this.started || this.byteSink == null) {
            SinkSubscriber.subscribe(this.completionSink, (Mono<Void>)Mono.empty());
        } else {
            this.byteSink.emitComplete(EMIT_FAILURE_HANDLER);
        }
    }

    public void write(byte[] bs, int off, int len) {
        try {
            ((CompletableFuture)this.asyncWrite(bs, off, len)).get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
    }

    public void flush() {
        try {
            ((CompletableFuture)this.asyncFlush()).get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
    }

    public CompletableFuture<Void> asyncFlush() {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> asyncWrite(byte[] bs, int offset, int length) {
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        if (!this.started) {
            this.byteSink = this.byteSinkSupplier.get();
            this.parentResponse.committed();
            this.started = true;
        }
        byte[] bytes = bs;
        if (offset != 0 || length != bs.length) {
            bytes = Arrays.copyOfRange(bs, offset, offset + length);
        }
        this.byteSink.emitNext((Object)Tuples.of((Object)bytes, cf), EMIT_FAILURE_HANDLER);
        return cf;
    }
}

