/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springboot;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public abstract class JaxrsApplicationScanner {
    private static final Logger logger = LoggerFactory.getLogger(JaxrsApplicationScanner.class);
    private static Map<String, Set<Class<? extends Application>>> packagesToClassesMap = new HashMap<String, Set<Class<? extends Application>>>();

    public static Set<Class<? extends Application>> getApplications(List<String> packagesToBeScanned) {
        String packagesKey = JaxrsApplicationScanner.createPackagesKey(packagesToBeScanned);
        if (!packagesToClassesMap.containsKey(packagesKey)) {
            packagesToClassesMap.put(packagesKey, JaxrsApplicationScanner.findJaxrsApplicationClasses(packagesToBeScanned));
        }
        return packagesToClassesMap.get(packagesKey);
    }

    private static String createPackagesKey(List<String> packagesToBeScanned) {
        return String.join((CharSequence)",", packagesToBeScanned);
    }

    private static Set<Class<? extends Application>> findJaxrsApplicationClasses(List<String> packagesToBeScanned) {
        logger.info("Scanning classpath to find JAX-RS Application classes");
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Application.class));
        HashSet candidates = new HashSet();
        for (String packageToScan : packagesToBeScanned) {
            Set candidatesSubSet = scanner.findCandidateComponents(packageToScan);
            candidates.addAll(candidatesSubSet);
        }
        HashSet<Class<? extends Application>> classes = new HashSet<Class<? extends Application>>();
        ClassLoader classLoader = JaxrsApplicationScanner.class.getClassLoader();
        for (BeanDefinition candidate : candidates) {
            try {
                Class type = ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)classLoader);
                classes.add(type);
            }
            catch (ClassNotFoundException e) {
                logger.error("JAX-RS Application subclass could not be loaded", (Throwable)e);
            }
        }
        classes.remove(Application.class);
        return classes;
    }
}

