/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springmvc;

import org.jboss.resteasy.spring.jetty.i18n.LogMessages;
import org.jboss.resteasy.spring.jetty.i18n.Messages;
import org.mortbay.jetty.Server;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JettyLifecycleManager
implements InitializingBean,
DisposableBean {
    private Server servletContainer;

    public Server getServletContainer() {
        return this.servletContainer;
    }

    public void setServletContainer(Server servletContainer) {
        this.servletContainer = servletContainer;
    }

    public void afterPropertiesSet() throws Exception {
        LogMessages.LOGGER.info(Messages.MESSAGES.startingJetty());
        try {
            this.servletContainer.start();
            while (!this.servletContainer.isStarted()) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            LogMessages.LOGGER.error(Messages.MESSAGES.interruptedWhileStartingJetty(), e);
        }
        catch (Exception e) {
            LogMessages.LOGGER.error(Messages.MESSAGES.exceptionWhileStartingJetty(), e);
        }
    }

    public void destroy() throws Exception {
        LogMessages.LOGGER.info(Messages.MESSAGES.shuttingDownJetty());
        try {
            this.servletContainer.stop();
        }
        catch (Exception e) {
            LogMessages.LOGGER.info(Messages.MESSAGES.exceptionWhileShuttingDownJetty(), e);
        }
    }
}

