/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.spring;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.plugins.spring.ResteasyRegistration;
import org.jboss.resteasy.plugins.spring.SpringResourceFactory;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.util.ClassUtils;

public class SpringBeanProcessor
implements BeanFactoryPostProcessor,
SmartApplicationListener {
    protected Registry registry;
    protected ResteasyProviderFactory providerFactory;
    protected Dispatcher dispatcher;
    protected Set<String> resourceFactoryNames;
    protected Map<String, SpringResourceFactory> resourceFactories = new HashMap<String, SpringResourceFactory>();
    protected Set<String> providerNames = new HashSet<String>();
    private Set<String> registrations = new HashSet<String>();
    private int order;

    public SpringBeanProcessor(ResteasyDeployment deployment) {
        this(deployment.getDispatcher(), deployment.getRegistry(), deployment.getProviderFactory());
    }

    public SpringBeanProcessor(Dispatcher dispatcher) {
        this(dispatcher, dispatcher.getRegistry(), dispatcher.getProviderFactory());
    }

    public SpringBeanProcessor(Dispatcher dispatcher, Registry registry, ResteasyProviderFactory providerFactory) {
        this.setRegistry(registry);
        this.setProviderFactory(providerFactory);
        this.setDispatcher(dispatcher);
    }

    public SpringBeanProcessor() {
    }

    @Required
    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerResolvableDependency(Registry.class, (Object)this.getRegistry());
        beanFactory.registerResolvableDependency(ResteasyProviderFactory.class, (Object)this.getProviderFactory());
        if (this.dispatcher != null) {
            beanFactory.registerResolvableDependency(Dispatcher.class, (Object)this.getDispatcher());
        }
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ResteasyBeanPostProcessor(beanFactory));
        ArrayList<String> dependsOnBeans = new ArrayList<String>();
        for (String name : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDef = beanFactory.getBeanDefinition(name);
            if (beanDef.getBeanClassName() == null && beanDef.getFactoryBeanName() == null || beanDef.isAbstract()) continue;
            this.processBean(beanFactory, dependsOnBeans, name, beanDef);
        }
        dependsOnBeans.addAll(this.registrations);
        String[] dependsOnArray = dependsOnBeans.toArray(new String[dependsOnBeans.size()]);
        if (dependsOnArray.length > 0) {
            for (SpringResourceFactory resourceFactory : this.resourceFactories.values()) {
                BeanDefinition beanDef = beanFactory.getBeanDefinition(resourceFactory.getBeanName());
                beanDef.setDependsOn(SpringBeanProcessor.concat(beanDef.getDependsOn(), dependsOnArray));
            }
        }
    }

    protected Class<?> processBean(ConfigurableListableBeanFactory beanFactory, List<String> dependsOnProviders, String name, BeanDefinition beanDef) {
        Class<?> beanClass = SpringBeanProcessor.getBeanClass(name, beanDef, beanFactory);
        if (beanClass.isAnnotationPresent(Provider.class)) {
            if (!SpringBeanProcessor.isSingleton(beanDef)) {
                throw new RuntimeException("Provider " + name + " is not a singleton.  That's not allowed");
            }
            this.providerNames.add(name);
            if (!MessageBodyWriter.class.isAssignableFrom(beanClass) && !MessageBodyReader.class.isAssignableFrom(beanClass)) {
                dependsOnProviders.add(name);
            }
        }
        if (GetRestful.isRootResource(beanClass)) {
            this.resourceFactories.put(name, new SpringResourceFactory(name, (BeanFactory)beanFactory, beanClass));
        }
        if (beanClass == ResteasyRegistration.class) {
            this.registrations.add(name);
        }
        return beanClass;
    }

    public String getPropertyValue(MutablePropertyValues registrationPropertyValues, String propertyName) {
        if (registrationPropertyValues == null) {
            return null;
        }
        PropertyValue propertyValue = registrationPropertyValues.getPropertyValue(propertyName);
        if (propertyValue == null) {
            return null;
        }
        Object value = propertyValue.getValue();
        if (value == null) {
            return null;
        }
        if (value.getClass() == String.class) {
            return (String)value;
        }
        if (value instanceof BeanReference) {
            return ((BeanReference)value).getBeanName();
        }
        throw new IllegalStateException("ResteasyRegistration references must be String values or a reference to a bean name");
    }

    private static String[] concat(String[] dependsOn, String[] dependsOnProviders) {
        if (dependsOn == null || dependsOn.length == 0) {
            return dependsOnProviders;
        }
        String[] result = new String[dependsOn.length + dependsOnProviders.length];
        System.arraycopy(dependsOn, 0, result, 0, dependsOn.length);
        System.arraycopy(dependsOnProviders, 0, result, dependsOn.length, dependsOnProviders.length);
        return result;
    }

    private static Class<?> getBeanClass(String name, BeanDefinition beanDef, ConfigurableListableBeanFactory beanFactory) {
        if (beanDef instanceof RootBeanDefinition) {
            RootBeanDefinition rootBeanDef = (RootBeanDefinition)beanDef;
            try {
                if (rootBeanDef.getBeanClass() != null) {
                    return rootBeanDef.getBeanClass();
                }
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        String factoryMethodName = beanDef.getFactoryMethodName();
        if (beanDef.getBeanClassName() != null && factoryMethodName == null) {
            return SpringBeanProcessor.getBeanClass(beanDef.getBeanClassName());
        }
        if (factoryMethodName != null) {
            Method[] methods;
            String factoryClassName = null;
            factoryClassName = beanDef instanceof AnnotatedBeanDefinition ? ((AnnotatedBeanDefinition)beanDef).getMetadata().getClassName() : (beanDef.getFactoryBeanName() != null ? beanFactory.getBeanDefinition(beanDef.getFactoryBeanName()).getBeanClassName() : beanDef.getBeanClassName());
            Class<?> beanClass = SpringBeanProcessor.getBeanClass(factoryClassName);
            for (Method method : methods = beanClass.getDeclaredMethods()) {
                if (!method.getName().equals(factoryMethodName)) continue;
                return method.getReturnType();
            }
            if (FactoryBean.class.isAssignableFrom(beanClass)) {
                Method method;
                String defaultFactoryMethod = "getObject";
                Class<?> returnType = null;
                Method[] arr$ = methods;
                int len$ = arr$.length;
                for (int i$ = 0; !(i$ >= len$ || (method = arr$[i$]).getName().equals(defaultFactoryMethod) && (returnType = method.getReturnType()) != Object.class); ++i$) {
                }
                if (returnType != null) {
                    return returnType;
                }
            }
        }
        throw new IllegalStateException("could not find the type for bean named " + name);
    }

    private static boolean isSingleton(BeanDefinition beanDef) {
        try {
            return beanDef.isSingleton();
        }
        catch (NoSuchBeanDefinitionException nsbde) {
            return false;
        }
    }

    private static Class<?> getBeanClass(String beanClassName) {
        try {
            return ClassUtils.forName((String)beanClassName, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not convert '" + beanClassName + "' to a class.", e);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        for (SpringResourceFactory resourceFactory : this.resourceFactories.values()) {
            this.getRegistry().removeRegistrations(resourceFactory.getScannableClass());
        }
        for (SpringResourceFactory resourceFactory : this.resourceFactories.values()) {
            this.getRegistry().addResourceFactory((ResourceFactory)resourceFactory, resourceFactory.getContext());
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType == ContextRefreshedEvent.class;
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return ApplicationContext.class.isAssignableFrom(sourceType);
    }

    protected class ResteasyBeanPostProcessor
    implements BeanPostProcessor {
        private ConfigurableListableBeanFactory beanFactory;

        protected ResteasyBeanPostProcessor(ConfigurableListableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (SpringBeanProcessor.this.providerNames.contains(beanName)) {
                PropertyInjector injector = this.getInjector(AopUtils.getTargetClass((Object)bean));
                injector.inject(bean);
                SpringBeanProcessor.this.providerFactory.registerProviderInstance(bean);
            } else if (SpringBeanProcessor.this.registrations.contains(beanName) && bean instanceof ResteasyRegistration) {
                ResteasyRegistration registration = (ResteasyRegistration)bean;
                String registeredBeanName = registration.getBeanName();
                BeanDefinition beanDef = this.beanFactory.getBeanDefinition(registeredBeanName);
                Class beanClass = SpringBeanProcessor.getBeanClass(registeredBeanName, beanDef, this.beanFactory);
                SpringResourceFactory resourceFactory = new SpringResourceFactory(registeredBeanName, (BeanFactory)this.beanFactory, beanClass);
                resourceFactory.setContext(registration.getContext());
                SpringBeanProcessor.this.resourceFactories.put(registeredBeanName, resourceFactory);
            } else {
                SpringResourceFactory resourceFactory = SpringBeanProcessor.this.resourceFactories.get(beanName);
                if (resourceFactory != null) {
                    this.inject(beanName, bean, this.getInjector(resourceFactory.getScannableClass()));
                }
            }
            return bean;
        }

        public PropertyInjector getInjector(Class<?> clazz) {
            return SpringBeanProcessor.this.providerFactory.getInjectorFactory().createPropertyInjector(clazz, SpringBeanProcessor.this.providerFactory);
        }

        public void inject(String beanName, Object bean, PropertyInjector propertyInjector) {
            if (propertyInjector == null) {
                return;
            }
            HttpRequest request = (HttpRequest)ResteasyProviderFactory.getContextData(HttpRequest.class);
            if (request == null || this.isSingleton(beanName)) {
                propertyInjector.inject(bean);
            } else {
                HttpResponse response = (HttpResponse)ResteasyProviderFactory.getContextData(HttpResponse.class);
                propertyInjector.inject(request, response, bean);
            }
        }

        private boolean isSingleton(String beanName) {
            boolean isSingleton = false;
            try {
                BeanDefinition beanDef = this.beanFactory.getBeanDefinition(beanName);
                isSingleton = beanDef.isSingleton();
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
            return isSingleton;
        }
    }
}

