/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.undertow;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import javax.servlet.ServletException;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.util.PortProvider;

public class UndertowJaxrsServer {
    final PathHandler root = new PathHandler();
    final ServletContainer container = ServletContainer.Factory.newInstance();
    protected Undertow server;

    public DeploymentInfo undertowDeployment(ResteasyDeployment deployment, String mapping) {
        if (mapping == null) {
            mapping = "/";
        }
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        if (!mapping.endsWith("/")) {
            mapping = mapping + "/";
        }
        mapping = mapping + "*";
        String prefix = null;
        if (!mapping.equals("/*")) {
            prefix = mapping.substring(0, mapping.length() - 2);
        }
        ServletInfo resteasyServlet = Servlets.servlet((String)"ResteasyServlet", HttpServlet30Dispatcher.class).setAsyncSupported(true).setLoadOnStartup(Integer.valueOf(1)).addMapping(mapping);
        if (prefix != null) {
            resteasyServlet.addInitParam("resteasy.servlet.mapping.prefix", prefix);
        }
        return new DeploymentInfo().addServletContextAttribute(ResteasyDeployment.class.getName(), (Object)deployment).addServlet(resteasyServlet);
    }

    public DeploymentInfo undertowDeployment(ResteasyDeployment deployment) {
        return this.undertowDeployment(deployment, "/");
    }

    public DeploymentInfo undertowDeployment(Class<? extends Application> application, String mapping) {
        ResteasyDeployment deployment = new ResteasyDeployment();
        deployment.setApplicationClass(application.getName());
        DeploymentInfo di = this.undertowDeployment(deployment, mapping);
        di.setClassLoader(application.getClassLoader());
        return di;
    }

    public DeploymentInfo undertowDeployment(Class<? extends Application> application) {
        ApplicationPath appPath = application.getAnnotation(ApplicationPath.class);
        String path = "/";
        if (appPath != null) {
            path = appPath.value();
        }
        return this.undertowDeployment(application, path);
    }

    public UndertowJaxrsServer deploy(ResteasyDeployment deployment) {
        return this.deploy(deployment, "/");
    }

    public UndertowJaxrsServer deploy(ResteasyDeployment deployment, String contextPath) {
        if (contextPath == null) {
            contextPath = "/";
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        DeploymentInfo builder = this.undertowDeployment(deployment);
        builder.setContextPath(contextPath);
        builder.setDeploymentName("Resteasy" + contextPath);
        return this.deploy(builder);
    }

    public UndertowJaxrsServer deploy(Class<? extends Application> application) {
        ApplicationPath appPath = application.getAnnotation(ApplicationPath.class);
        String path = "/";
        if (appPath != null) {
            path = appPath.value();
        }
        return this.deploy(application, path);
    }

    public UndertowJaxrsServer deploy(Class<? extends Application> application, String contextPath) {
        if (contextPath == null) {
            contextPath = "/";
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        ResteasyDeployment deployment = new ResteasyDeployment();
        deployment.setApplicationClass(application.getName());
        DeploymentInfo di = this.undertowDeployment(deployment);
        di.setClassLoader(application.getClassLoader());
        di.setContextPath(contextPath);
        di.setDeploymentName("Resteasy" + contextPath);
        return this.deploy(di);
    }

    public UndertowJaxrsServer deploy(Application application) {
        ApplicationPath appPath = application.getClass().getAnnotation(ApplicationPath.class);
        String path = "/";
        if (appPath != null) {
            path = appPath.value();
        }
        return this.deploy(application, path);
    }

    public UndertowJaxrsServer deploy(Application application, String contextPath) {
        if (contextPath == null) {
            contextPath = "/";
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        ResteasyDeployment deployment = new ResteasyDeployment();
        deployment.setApplication(application);
        DeploymentInfo di = this.undertowDeployment(deployment);
        di.setClassLoader(application.getClass().getClassLoader());
        di.setContextPath(contextPath);
        di.setDeploymentName("Resteasy" + contextPath);
        return this.deploy(di);
    }

    public UndertowJaxrsServer deploy(DeploymentInfo builder) {
        DeploymentManager manager = this.container.addDeployment(builder);
        manager.deploy();
        try {
            this.root.addPath(builder.getContextPath(), manager.start());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public UndertowJaxrsServer start(Undertow.Builder builder) {
        this.server = builder.setHandler((HttpHandler)this.root).build();
        this.server.start();
        return this;
    }

    public UndertowJaxrsServer start() {
        this.server = Undertow.builder().addListener(PortProvider.getPort(), "localhost").setHandler((HttpHandler)this.root).build();
        this.server.start();
        return this;
    }

    public void stop() {
        this.server.stop();
    }
}

