/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.vertx;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedJaxrsServer;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.vertx.VertxRequestHandler;
import org.jboss.resteasy.plugins.server.vertx.VertxResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class VertxJaxrsServer
implements EmbeddedJaxrsServer {
    private static final ConcurrentMap<String, Helper> deploymentMap = new ConcurrentHashMap<String, Helper>();
    protected VertxOptions vertxOptions = new VertxOptions();
    protected Vertx vertx;
    protected HttpServerOptions serverOptions = new HttpServerOptions();
    protected VertxResteasyDeployment deployment = new VertxResteasyDeployment();
    protected String root = "";
    protected SecurityDomain domain;
    private String deploymentID;

    public String getHostname() {
        return this.serverOptions.getHost();
    }

    public void setHostname(String hostname) {
        this.serverOptions.setHost(hostname);
    }

    public int getPort() {
        return this.serverOptions.getPort();
    }

    public void setPort(int port) {
        this.serverOptions.setPort(port);
    }

    public VertxOptions getVertxOptions() {
        return this.vertxOptions;
    }

    public void setVertxOptions(VertxOptions options) {
        this.vertxOptions = options;
    }

    public void setServerOptions(HttpServerOptions options) {
        this.serverOptions = options;
    }

    public HttpServerOptions getServerOptions() {
        return this.serverOptions;
    }

    public void setDeployment(ResteasyDeployment deployment) {
        this.deployment = (VertxResteasyDeployment)deployment;
    }

    public void setRootResourcePath(String rootResourcePath) {
        this.root = rootResourcePath;
        if (this.root != null && this.root.equals("/")) {
            this.root = "";
        }
    }

    public VertxResteasyDeployment getDeployment() {
        return this.deployment;
    }

    public void setSecurityDomain(SecurityDomain sc) {
        this.domain = sc;
    }

    public void start() {
        this.vertx = Vertx.vertx((VertxOptions)this.vertxOptions);
        this.deployment.start();
        String key = UUID.randomUUID().toString();
        deploymentMap.put(key, new Helper(this.root, this.serverOptions, (ResteasyDeployment)this.deployment, this.domain));
        CompletableFuture fut = new CompletableFuture();
        DeploymentOptions deploymentOptions = new DeploymentOptions().setInstances(this.vertxOptions.getEventLoopPoolSize()).setConfig(new JsonObject().put("helper", key));
        this.vertx.deployVerticle(Verticle.class.getName(), deploymentOptions, ar -> {
            deploymentMap.remove(key);
            if (ar.succeeded()) {
                fut.complete(ar.result());
            } else {
                fut.completeExceptionally(ar.cause());
            }
        });
        try {
            this.deploymentID = (String)fut.get(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (this.deploymentID != null) {
            CompletableFuture fut = new CompletableFuture();
            this.vertx.close(ar -> fut.complete(null));
            this.deploymentID = null;
            try {
                fut.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class Verticle
    extends AbstractVerticle {
        protected HttpServer server;

        public void start(Future<Void> startFuture) throws Exception {
            Helper helper = (Helper)deploymentMap.get(this.config().getString("helper"));
            this.server = this.vertx.createHttpServer(helper.serverOptions);
            this.server.requestHandler((Handler)new VertxRequestHandler(this.vertx, helper.deployment, helper.root, helper.domain));
            this.server.listen(ar -> {
                if (ar.succeeded()) {
                    startFuture.complete();
                } else {
                    startFuture.fail(ar.cause());
                }
            });
        }
    }

    private static class Helper {
        final String root;
        final HttpServerOptions serverOptions;
        final ResteasyDeployment deployment;
        final SecurityDomain domain;

        Helper(String root, HttpServerOptions serverOptions, ResteasyDeployment deployment, SecurityDomain domain) {
            this.root = root;
            this.serverOptions = serverOptions;
            this.deployment = deployment;
            this.domain = domain;
        }

        public Handler<HttpServerRequest> createHandler(Vertx vertx) {
            return new VertxRequestHandler(vertx, this.deployment, this.root, this.domain);
        }
    }
}

