/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.sasl.util.Charsets;
import org.jboss.sasl.util.HexConverter;

public class UsernamePasswordHashUtil {
    private static final String MD5 = "MD5";
    private static final byte COLON = 58;
    private final MessageDigest digest;

    public UsernamePasswordHashUtil() throws NoSuchAlgorithmException {
        this.digest = MessageDigest.getInstance(MD5);
    }

    public UsernamePasswordHashUtil(MessageDigest digest) {
        this.digest = digest;
    }

    private byte[] stringToByte(String toConvert, boolean allowUTF8) {
        if (allowUTF8) {
            char[] theChars;
            for (char c : theChars = toConvert.toCharArray()) {
                if (c <= '\u00ff') continue;
                return toConvert.getBytes(Charsets.UTF_8);
            }
        }
        return toConvert.getBytes(Charsets.EIGHT859_1);
    }

    private byte[] stringToByte(char[] toConvert, boolean allowUTF8) {
        if (allowUTF8) {
            for (char c : toConvert) {
                if (c <= '\u00ff') continue;
                return String.valueOf(toConvert).getBytes(Charsets.UTF_8);
            }
        }
        return String.valueOf(toConvert).getBytes(Charsets.EIGHT859_1);
    }

    public byte[] generateHashedURP(String userName, String realm, char[] password, boolean utf8StringConversion) {
        byte[] userNameArray = this.stringToByte(userName, utf8StringConversion);
        byte[] realmArray = this.stringToByte(realm, utf8StringConversion);
        byte[] passwordArray = this.stringToByte(password, utf8StringConversion);
        int requiredSize = userNameArray.length + realmArray.length + passwordArray.length + 2;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(requiredSize);
            baos.write(userNameArray);
            baos.write(58);
            baos.write(realmArray);
            baos.write(58);
            baos.write(passwordArray);
            return this.digest.digest(baos.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException("The ByteArrayOutputStream should not be throwing this IOException", e);
        }
    }

    public byte[] generateHashedURP(String userName, String realm, char[] password) {
        return this.generateHashedURP(userName, realm, password, true);
    }

    public String generateHashedHexURP(String userName, String realm, char[] password, boolean utf8StringConversion) {
        byte[] hashedURP = this.generateHashedURP(userName, realm, password, utf8StringConversion);
        return HexConverter.convertToHexString(hashedURP);
    }

    public String generateHashedHexURP(String userName, String realm, char[] password) {
        return this.generateHashedHexURP(userName, realm, password, true);
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        char[] password;
        String realm;
        String userName;
        if (args.length == 2) {
            userName = args[0];
            realm = "";
            password = args[1].toCharArray();
        } else if (args.length == 3) {
            userName = args[0];
            realm = args[1];
            password = args[2].toCharArray();
        } else {
            System.out.println("Usage : UsernamePasswordHashUtil UserName [Realm] Password");
            return;
        }
        UsernamePasswordHashUtil util = new UsernamePasswordHashUtil();
        System.out.println(userName + "=" + util.generateHashedHexURP(userName, realm, password));
    }
}

