/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.localuser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import org.jboss.sasl.util.AbstractSaslClient;
import org.jboss.sasl.util.Charsets;
import org.jboss.sasl.util.SaslState;
import org.jboss.sasl.util.SaslStateContext;

public final class LocalUserClient
extends AbstractSaslClient {
    LocalUserClient(String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId) {
        super("JBOSS-LOCAL-USER", protocol, serverName, callbackHandler, authorizationId, true);
    }

    @Override
    public void init() {
        this.getContext().setNegotiationState(new SaslState(){

            @Override
            public byte[] evaluateMessage(SaslStateContext context, byte[] message) throws SaslException {
                String authorizationId = LocalUserClient.this.getAuthorizationId();
                byte[] bytes = new byte[Charsets.encodedLengthOf(authorizationId)];
                Charsets.encodeTo(authorizationId, bytes, 0);
                context.setNegotiationState(new SaslState(){

                    @Override
                    public byte[] evaluateMessage(SaslStateContext context, byte[] message) throws SaslException {
                        String path = new String(message, Charsets.UTF_8);
                        File file = new File(path);
                        byte[] challenge = new byte[8];
                        try {
                            int r;
                            FileInputStream stream = new FileInputStream(file);
                            for (int t = 0; t < 8; t += r) {
                                r = stream.read(challenge, t, 8 - t);
                                if (r >= 0) continue;
                                throw new SaslException("Invalid server challenge");
                            }
                        }
                        catch (IOException e) {
                            throw new SaslException("Failed to read server challenge", e);
                        }
                        String authenticationId = LocalUserClient.this.getAuthorizationId();
                        NameCallback nameCallback = new NameCallback("User name", authenticationId);
                        RealmCallback realmCallback = new RealmCallback("User realm");
                        LocalUserClient.this.handleCallbacks(new Callback[]{nameCallback, realmCallback});
                        authenticationId = nameCallback.getName();
                        String authenticationRealm = realmCallback.getText();
                        if (authenticationId == null) {
                            authenticationId = "";
                        }
                        if (authenticationRealm == null) {
                            authenticationRealm = "";
                        }
                        int authenticationIdLength = Charsets.encodedLengthOf(authenticationId);
                        int authenticationRealmLength = Charsets.encodedLengthOf(authenticationRealm);
                        byte[] response = new byte[9 + authenticationIdLength + authenticationRealmLength];
                        System.arraycopy(challenge, 0, response, 0, 8);
                        Charsets.encodeTo(authenticationId, response, 8);
                        Charsets.encodeTo(authenticationRealm, response, 9 + authenticationIdLength);
                        context.negotiationComplete();
                        return response;
                    }
                });
                return bytes;
            }
        });
    }
}

