/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.deployers.filter;

import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.helpers.VFS2BaseBridgeDeploymentUnitFilter;
import org.jboss.scanning.plugins.filter.ScanningMetaDataRecurseFilter;
import org.jboss.scanning.plugins.filter.ScanningMetaDataResourceFilter;
import org.jboss.scanning.plugins.helpers.DelegateResourceFilter;
import org.jboss.scanning.spi.metadata.ScanningMetaData;

public class ScanningDeploymentUnitFilter
extends VFS2BaseBridgeDeploymentUnitFilter {
    protected boolean doAccepts(DeploymentUnit unit) {
        ScanningMetaData smd = (ScanningMetaData)unit.getAttachment(ScanningMetaData.class);
        if (smd != null) {
            ResourceFilter filter;
            ResourceFilter recurse = this.createRecurseFilter(smd);
            if (recurse != null) {
                ResourceFilter previousRecurse = (ResourceFilter)unit.getAttachment(ResourceFilter.class.getName() + ".recurse", ResourceFilter.class);
                if (previousRecurse != null) {
                    recurse = new DelegateResourceFilter(previousRecurse, recurse);
                }
                unit.addAttachment(ResourceFilter.class.getName() + ".recurse", (Object)recurse, ResourceFilter.class);
            }
            if ((filter = this.createResourceFilter(smd)) != null) {
                ResourceFilter previousFilter = (ResourceFilter)unit.getAttachment(ResourceFilter.class.getName() + ".resource", ResourceFilter.class);
                if (previousFilter != null) {
                    filter = new DelegateResourceFilter(previousFilter, filter);
                }
                unit.addAttachment(ResourceFilter.class.getName() + ".resource", (Object)filter, ResourceFilter.class);
            }
        }
        return true;
    }

    protected ResourceFilter createRecurseFilter(ScanningMetaData smd) {
        return new ScanningMetaDataRecurseFilter(smd);
    }

    protected ResourceFilter createResourceFilter(ScanningMetaData smd) {
        return new ScanningMetaDataResourceFilter(smd);
    }
}

