/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.filter;

import java.net.URL;
import java.util.List;
import java.util.Set;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.PackageClassFilter;
import org.jboss.classloader.spi.filter.RecursivePackageClassFilter;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.scanning.spi.metadata.FilterablePathEntry;
import org.jboss.scanning.spi.metadata.PathEntryMetaData;
import org.jboss.scanning.spi.metadata.PathMetaData;
import org.jboss.scanning.spi.metadata.ScanningMetaData;

public class ScanningMetaDataResourceFilter
implements ResourceFilter {
    private ScanningMetaData smd;

    public ScanningMetaDataResourceFilter(ScanningMetaData smd) {
        if (smd == null) {
            throw new IllegalArgumentException("Null metadata");
        }
        this.smd = smd;
    }

    public boolean accepts(ResourceContext resource) {
        if (!resource.isClass()) {
            return false;
        }
        URL url = resource.getUrl();
        String urlString = url.toExternalForm();
        List paths = this.smd.getPaths();
        if (paths != null && !paths.isEmpty()) {
            for (PathMetaData pmda : paths) {
                Set excludes;
                String name = pmda.getPathName();
                if (!urlString.contains(name)) continue;
                String resourceName = resource.getResourceName();
                boolean explicitInclude = false;
                Set includes = pmda.getIncludes();
                if (includes != null && !includes.isEmpty()) {
                    explicitInclude = true;
                    for (PathEntryMetaData pemda : includes) {
                        ClassFilter filter = this.getClassFilter(pemda);
                        if (!filter.matchesResourcePath(resourceName)) continue;
                        return true;
                    }
                }
                if (!explicitInclude && (excludes = pmda.getExcludes()) != null && !excludes.isEmpty()) {
                    for (PathEntryMetaData pemda : excludes) {
                        ClassFilter filter = this.getClassFilter(pemda);
                        if (!filter.matchesResourcePath(resourceName)) continue;
                        return false;
                    }
                }
                return !explicitInclude;
            }
        }
        return false;
    }

    protected ClassFilter getClassFilter(PathEntryMetaData pemd) {
        if (pemd instanceof FilterablePathEntry) {
            return ((FilterablePathEntry)pemd).getFilter();
        }
        if (pemd.isRecurse()) {
            return RecursivePackageClassFilter.createRecursivePackageClassFilter((String[])new String[]{pemd.getName()});
        }
        return PackageClassFilter.createPackageClassFilter((String[])new String[]{pemd.getName()});
    }
}

