/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.helpers;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.jboss.util.JBossObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WeakClassLoaderHolder
extends JBossObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient WeakReference<ClassLoader> clRef;

    public WeakClassLoaderHolder() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public WeakClassLoaderHolder(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        this.clRef = new WeakReference<ClassLoader>(classLoader);
    }

    protected ClassLoader getClassLoader() {
        if (this.clRef == null) {
            throw new IllegalArgumentException("Null classloader ref, previously serialized?");
        }
        ClassLoader classLoader = (ClassLoader)this.clRef.get();
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader was already garbage collected.");
        }
        return classLoader;
    }

    protected Class<?> loadClass(String className) {
        try {
            return this.loadClassWithCNFE(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected Class<?> loadClassWithCNFE(String className) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(className);
    }
}

