/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.visitor;

import java.util.HashSet;
import java.util.Set;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.logging.Logger;
import org.jboss.scanning.plugins.visitor.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoreSetErrorHandler
implements ErrorHandler {
    private static final Logger log = Logger.getLogger(IgnoreSetErrorHandler.class);
    private Set<Class<Throwable>> ignore = new HashSet<Class<Throwable>>();

    @Override
    public void handleError(ResourceVisitor visitor, ResourceContext resource, Throwable t) {
        for (Class<Throwable> i : this.ignore) {
            if (!i.isInstance(t)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Ignoring resource (" + resource + ") at visitor (" + visitor + "), error: " + t));
            }
            return;
        }
        throw new RuntimeException("Error visiting resource: " + resource + ", visitor: " + visitor, t);
    }

    public void addIgnored(Class<Throwable> t) {
        if (t == null) {
            throw new IllegalArgumentException("Null class");
        }
        this.ignore.add(t);
    }

    public void removeIgnored(Class<Throwable> t) {
        if (t == null) {
            throw new IllegalArgumentException("Null class");
        }
        this.ignore.remove(t);
    }
}

