/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.indexer.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLWriter {
    private static Logger log = Logger.getLogger(HTMLWriter.class.getName());
    protected static final String NEW_LINE = System.getProperty("line.separator");

    private HTMLWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateCSS(File directory) {
        byte[] buffer = new byte[8192];
        InputStream is = null;
        OutputStream os = null;
        try {
            is = HTMLWriter.class.getClassLoader().getResourceAsStream("style.css");
            if (is != null) {
                int bytesRead;
                os = new FileOutputStream(directory.getAbsolutePath() + File.separator + "style.css");
                while ((bytesRead = is.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
                os.flush();
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, t.getMessage(), t);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateReport(File directory, String name, Map<String, Collection<String>> data) {
        BufferedWriter bw = null;
        try {
            FileWriter fw = new FileWriter(directory.getAbsolutePath() + File.separator + name + ".html");
            bw = new BufferedWriter(fw, 8192);
            bw.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\"http://www.w3.org/TR/html4/loose.dtd\">" + NEW_LINE);
            bw.write("<html>" + NEW_LINE);
            bw.write("<head>" + NEW_LINE);
            bw.write("  <title>Scanning: " + name + "</title>" + NEW_LINE);
            bw.write("  <meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\">" + NEW_LINE);
            bw.write("  <link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\">" + NEW_LINE);
            bw.write("</head>" + NEW_LINE);
            bw.write("<body>" + NEW_LINE);
            bw.write(NEW_LINE);
            bw.write("<h1>Scanning: " + name + "</h1>" + NEW_LINE);
            bw.write("<table>" + NEW_LINE);
            bw.write("  <tr>" + NEW_LINE);
            bw.write("     <th>Annotation</th>" + NEW_LINE);
            bw.write("     <th>Location</th>" + NEW_LINE);
            bw.write("  </tr>" + NEW_LINE);
            boolean odd = true;
            for (Map.Entry<String, Collection<String>> entry : data.entrySet()) {
                String annotation = entry.getKey();
                Collection<String> classes = entry.getValue();
                if (odd) {
                    bw.write("  <tr class=\"rowodd\">" + NEW_LINE);
                } else {
                    bw.write("  <tr class=\"roweven\">" + NEW_LINE);
                }
                bw.write("     <td>" + annotation + "</td>" + NEW_LINE);
                bw.write("     <td>");
                Iterator<String> cit = classes.iterator();
                while (cit.hasNext()) {
                    bw.write(cit.next());
                    if (!cit.hasNext()) continue;
                    bw.write(", ");
                }
                bw.write("</td>" + NEW_LINE);
                bw.write("  </tr>" + NEW_LINE);
                odd = !odd;
            }
            bw.write("</table>" + NEW_LINE);
            bw.write(NEW_LINE);
            bw.write("<p>" + NEW_LINE);
            bw.write("<hr>" + NEW_LINE);
            bw.write("Generated by: <a href=\"http://www.jboss.org/projects/jbossmc\">Scanning</a>" + NEW_LINE);
            bw.write(NEW_LINE);
            bw.write("</body>" + NEW_LINE);
            bw.write("</html>" + NEW_LINE);
            bw.flush();
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, t.getMessage(), t);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException ioe) {}
        }
    }
}

