/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.scanning.spi.helpers;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

import org.jboss.scanning.spi.Scanner;
import org.jboss.scanning.spi.ScanningPlugin;

/**
 * Abstract scanner.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public abstract class AbstractScanner implements Scanner
{
   /** The plugins */
   private Set<ScanningPlugin> plugins = new CopyOnWriteArraySet<ScanningPlugin>();

   /**
    * Add plugin.
    *
    * @param plugin the plugin
    */
   public void addPlugin(ScanningPlugin plugin)
   {
      if (plugin == null)
         throw new IllegalArgumentException("Null plugin");

      plugins.add(plugin);
   }

   /**
    * Remove the plugin.
    *
    * @param plugin the plugin
    */
   public void removePlugin(ScanningPlugin plugin)
   {
      if (plugin == null)
         return;

      plugins.remove(plugin);
   }

   /**
    * Get plugins.
    *
    * @return the plugins
    */
   public Set<ScanningPlugin> getPlugins()
   {
      return Collections.unmodifiableSet(plugins);
   }

   /**
    * Set the plugins.
    *
    * @param plugins the plugins
    */
   public void setPlugins(Set<ScanningPlugin> plugins)
   {
      if (plugins == null)
         throw new IllegalArgumentException("Null plugins");
      this.plugins = plugins;
   }
}
