/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.cron.examples.swinggrapher;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.seam.cron.api.scheduling.Every;
import org.jboss.seam.cron.api.scheduling.Interval;
import org.jboss.seam.cron.api.scheduling.Scheduled;
import org.jboss.seam.cron.api.scheduling.Trigger;
import org.jfree.data.category.DefaultCategoryDataset;

@ApplicationScoped
public class SwingGrapher {
    public static final String FREE_MEMORY_LABEL = "Free Memory";
    private final DefaultCategoryDataset catDataSet = new DefaultCategoryDataset();
    @Inject
    Logger log;

    @Produces
    public DefaultCategoryDataset getCatDataSet() {
        return this.catDataSet;
    }

    public void updateChart(@Observes @Every(value=Interval.SECOND) Trigger second) {
        this.getCatDataSet().addValue((double)Runtime.getRuntime().freeMemory(), (Comparable)((Object)FREE_MEMORY_LABEL), (Comparable)((Object)new Long(System.currentTimeMillis()).toString()));
    }

    public void collectGarbage(@Observes @Every(value=Interval.MINUTE) Trigger minute) {
        this.log.info((Object)"Requesting garbage collection");
        System.gc();
    }

    public void clearGraphData(@Observes @Scheduled(value="20 */2 * ? * *") Trigger e) {
        this.log.info((Object)"Clearing data on schedule");
        this.getCatDataSet().clear();
    }
}

