/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.cron.scheduling.quartz;

import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.seam.cron.api.scheduling.Every;
import org.jboss.seam.cron.api.scheduling.Interval;
import org.jboss.seam.cron.impl.scheduling.exception.CronProviderDestructionException;
import org.jboss.seam.cron.impl.scheduling.exception.CronProviderInitialisationException;
import org.jboss.seam.cron.scheduling.quartz.TriggerJob;
import org.jboss.seam.cron.spi.CronProviderLifecycle;
import org.jboss.seam.cron.spi.scheduling.CronSchedulingProvider;
import org.jboss.seam.cron.spi.scheduling.trigger.IntervalTriggerDetail;
import org.jboss.seam.cron.spi.scheduling.trigger.ScheduledTriggerDetail;
import org.jboss.seam.cron.spi.scheduling.trigger.TriggerDetail;
import org.jboss.seam.cron.spi.scheduling.trigger.TriggerSupplies;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;

public class QuartzScheduleProvider
implements CronProviderLifecycle,
CronSchedulingProvider {
    public static final String QUALIFIER = "qualifier";
    public static final String SCHEDULE_JOB_GROUP = "schedule_job_group";
    public static final String MANAGER_NAME = "manager";
    public static final String TRIGGER_SUPPLIES = "trigger_helper";
    private static final String SCHEDULER_NAME_PREFIX = "SeamCronScheduler";
    private String schedulerName;
    private Scheduler scheduler;
    private UUID instanceId;
    private static final Logger log = Logger.getLogger(QuartzScheduleProvider.class);
    @Inject
    BeanManager beanManager;

    public void initProvider() throws CronProviderInitialisationException {
        this.instanceId = UUID.randomUUID();
        RAMJobStore jobStore = new RAMJobStore();
        SimpleThreadPool threadPool = new SimpleThreadPool(4, 5);
        try {
            threadPool.initialize();
        }
        catch (SchedulerConfigException ex) {
            throw new CronProviderInitialisationException("Error initializing Quartz ThreadPool", (Throwable)ex);
        }
        DirectSchedulerFactory schedulerFactory = DirectSchedulerFactory.getInstance();
        this.schedulerName = "SeamCronScheduler_" + this.instanceId.toString();
        try {
            schedulerFactory.createScheduler(this.schedulerName, this.instanceId.toString(), (ThreadPool)threadPool, (JobStore)jobStore);
            this.scheduler = schedulerFactory.getScheduler(this.schedulerName);
            this.scheduler.start();
        }
        catch (SchedulerException ex) {
            throw new CronProviderInitialisationException("Error initializing Quartz scheduler", (Throwable)ex);
        }
    }

    public void processScheduledTrigger(ScheduledTriggerDetail schedTriggerDetails) throws ParseException, SchedulerException, InternalError {
        CronTrigger schedTrigger = new CronTrigger(schedTriggerDetails.toString(), SCHEDULE_JOB_GROUP, schedTriggerDetails.getCronScheduleSpec());
        this.scheduleJob((Trigger)schedTrigger, (TriggerDetail)schedTriggerDetails);
    }

    public void processIntervalTrigger(IntervalTriggerDetail intervalTriggerDetails) throws ParseException, SchedulerException, InternalError {
        Trigger schedTrigger = null;
        if (Interval.SECOND.equals((Object)intervalTriggerDetails.getRepeatUnit())) {
            schedTrigger = TriggerUtils.makeSecondlyTrigger((int)intervalTriggerDetails.getRepeatInterval());
        } else if (Interval.MINUTE.equals((Object)intervalTriggerDetails.getRepeatUnit())) {
            schedTrigger = TriggerUtils.makeMinutelyTrigger((int)intervalTriggerDetails.getRepeatInterval());
        } else if (Interval.HOUR.equals((Object)intervalTriggerDetails.getRepeatUnit())) {
            schedTrigger = TriggerUtils.makeHourlyTrigger((int)intervalTriggerDetails.getRepeatInterval());
        } else {
            throw new InternalError("Could not work out which interval to use for the schedule of an @" + Every.class.getName() + " observer");
        }
        schedTrigger.setJobGroup(SCHEDULE_JOB_GROUP);
        this.scheduleJob(schedTrigger, (TriggerDetail)intervalTriggerDetails);
    }

    public void destroyProvider() throws CronProviderDestructionException {
        try {
            this.getScheduler().shutdown();
        }
        catch (SchedulerException ex) {
            log.warn((Object)"Error shutting down scheduler", (Throwable)ex);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    private void scheduleJob(Trigger schedTrigger, TriggerDetail triggerDetails) throws CronProviderInitialisationException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.add(13, 1);
        Date startTime = new Date(gc.getTimeInMillis());
        schedTrigger.setStartTime(startTime);
        String jobName = triggerDetails.toString() + "-trigger";
        schedTrigger.setName(jobName);
        JobDetail job = new JobDetail(jobName, schedTrigger.getGroup(), TriggerJob.class);
        job.setJobDataMap(new JobDataMap());
        job.getJobDataMap().put((Object)TRIGGER_SUPPLIES, (Object)new TriggerSupplies(this.beanManager, triggerDetails.getQualifier()));
        try {
            this.getScheduler().scheduleJob(job, schedTrigger);
        }
        catch (SchedulerException e) {
            throw new CronProviderInitialisationException("Error scheduling job " + jobName + " with Quartz provider", (Throwable)e);
        }
        log.info((Object)("Scheduler for " + jobName + " initialised"));
    }
}

