/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.util.Map;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.ejb.AbstractEntityManagerImpl;
import org.hibernate.engine.SessionImplementor;

public class EntityManagerImpl
extends AbstractEntityManagerImpl {
    private static Log log = LogFactory.getLog(EntityManagerImpl.class);
    protected Session session;
    protected SessionFactory sessionFactory;
    protected boolean open;
    protected boolean discardOnClose;
    private Class sessionInterceptorClass;

    public EntityManagerImpl(SessionFactory sessionFactory, PersistenceContextType pcType, PersistenceUnitTransactionType transactionType, boolean discardOnClose, Class sessionInterceptorClass, Map properties) {
        super(pcType, transactionType, properties);
        this.sessionFactory = sessionFactory;
        this.open = true;
        this.discardOnClose = discardOnClose;
        Object localSic = null;
        if (properties != null) {
            localSic = properties.get("hibernate.ejb.interceptor.session_scoped");
        }
        if (localSic != null) {
            if (localSic instanceof Class) {
                sessionInterceptorClass = localSic;
            } else if (localSic instanceof String) {
                try {
                    sessionInterceptorClass = ReflectHelper.classForName(localSic, EntityManagerImpl.class);
                }
                catch (ClassNotFoundException e) {
                    throw new PersistenceException("Unable to instanciate interceptor: " + localSic, e);
                }
            } else {
                throw new PersistenceException("Unable to instanciate interceptor: " + localSic);
            }
        }
        this.sessionInterceptorClass = sessionInterceptorClass;
        this.postInit();
    }

    public Session getSession() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        return this.getRawSession();
    }

    protected Session getRawSession() {
        if (this.session == null) {
            Interceptor interceptor = null;
            if (this.sessionInterceptorClass != null) {
                try {
                    interceptor = (Interceptor)this.sessionInterceptorClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new PersistenceException("Unable to instanciate session interceptor: " + this.sessionInterceptorClass, e);
                }
                catch (IllegalAccessException e) {
                    throw new PersistenceException("Unable to instanciate session interceptor: " + this.sessionInterceptorClass, e);
                }
                catch (ClassCastException e) {
                    throw new PersistenceException("Session interceptor does not implement Interceptor: " + this.sessionInterceptorClass, e);
                }
            }
            this.session = this.sessionFactory.openSession(interceptor);
            if (this.persistenceContextType == PersistenceContextType.TRANSACTION) {
                ((SessionImplementor)((Object)this.session)).setAutoClear(true);
            }
        }
        return this.session;
    }

    public void close() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        if (!this.discardOnClose && this.isTransactionInProgress()) {
            this.getSession().getTransaction().registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int i) {
                    if (EntityManagerImpl.this.session != null) {
                        if (EntityManagerImpl.this.session.isOpen()) {
                            log.debug((Object)"Closing entity manager after transaction completion");
                            EntityManagerImpl.this.session.close();
                        } else {
                            log.warn((Object)"Entity Manager closed by someone else (hibernate.transaction.auto_close_session must not be used)");
                        }
                    }
                }
            });
        } else if (this.session != null) {
            this.session.close();
        }
        this.open = false;
    }

    public boolean isOpen() {
        try {
            if (this.open) {
                this.getSession().isOpen();
            }
            return this.open;
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return false;
        }
    }
}

