/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.optimization;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.optimization.OptimizerStrategy;

public class IncrementalOptimizerStrategy
implements OptimizerStrategy {
    private int operationMax = -1;
    private int transactionMax = -1;
    private long operations = 0L;
    private long transactions = 0L;
    private DirectoryProvider directoryProvider;
    private Log log = LogFactory.getLog(IncrementalOptimizerStrategy.class);

    public void initialize(DirectoryProvider directoryProvider, Properties indexProperties, SearchFactoryImplementor searchFactoryImplementor) {
        this.directoryProvider = directoryProvider;
        String maxString = indexProperties.getProperty("optimizer.operation_limit.max");
        if (StringHelper.isNotEmpty(maxString)) {
            this.operationMax = Integer.parseInt(maxString);
        }
        if (StringHelper.isNotEmpty(maxString = indexProperties.getProperty("optimizer.transaction_limit.max"))) {
            this.transactionMax = Integer.parseInt(maxString);
        }
    }

    public void optimizationForced() {
        this.operations = 0L;
        this.transactions = 0L;
    }

    public boolean needOptimization() {
        return this.operationMax != -1 && this.operations >= (long)this.operationMax || this.transactionMax != -1 && this.transactions >= (long)this.transactionMax;
    }

    public void addTransaction(long operations) {
        this.operations += operations;
        ++this.transactions;
    }

    public void optimize(Workspace workspace) {
        if (this.needOptimization()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Optimize " + this.directoryProvider.getDirectory().toString() + " after " + this.operations + " operations and " + this.transactions + " transactions"));
            }
            IndexWriter writer = workspace.getIndexWriter(this.directoryProvider);
            try {
                writer.optimize();
            }
            catch (IOException e) {
                throw new SearchException("Unable to optimize directoryProvider: " + this.directoryProvider.getDirectory().toString(), e);
            }
            this.optimizationForced();
        }
    }
}

