// $Id: Key.java 14716 2008-05-30 15:49:57Z sannegrinovero $
package org.hibernate.search.annotations;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.annotation.ElementType;
import java.lang.annotation.Documented;

/**
 * Marks a method as a key constructor for a given type.
 * A key is an object that uniquely identify a given object type and a given set of parameters
 *
 * The key object must implement equals / hashcode so that 2 keys are equals iif
 * the given target object types are the same, the set of parameters are the same.
 *
 * &#64;Factory currently works for &#64;FullTextFilterDef.impl classes
 * @see org.hibernate.search.annotations.Factory
 * @author Emmanuel Bernard
 */
@Retention( RetentionPolicy.RUNTIME )
@Target( ElementType.METHOD )
@Documented
public @interface Key {
}
