// $Id: OptimizeLuceneWork.java 15224 2008-09-29 15:35:13Z sannegrinovero $
package org.hibernate.search.backend;

import java.io.Serializable;

/**
 * A unit of work triggering an optimize operation.
 * This work does not propagate to a cluster: it should be filtered before being sent to
 * the network.
 *
 * @author Andrew Hahn
 * @author Emmanuel Bernard
 */
public class OptimizeLuceneWork extends LuceneWork implements Serializable {
	
	public OptimizeLuceneWork(Class entity) {
		super( null, null, entity );
	}

	@Override
	public <T> T getWorkDelegate(final WorkVisitor<T> visitor) {
		return visitor.getDelegate( this );
	}
	
}
