/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.cglib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.ProtectionDomain;
import net.sf.cglib.core.ClassGenerator;
import net.sf.cglib.core.ClassNameReader;
import net.sf.cglib.core.DebuggingClassWriter;
import net.sf.cglib.transform.ClassReaderGenerator;
import net.sf.cglib.transform.ClassTransformer;
import net.sf.cglib.transform.TransformingClassGenerator;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import net.sf.cglib.transform.impl.InterceptFieldFilter;
import net.sf.cglib.transform.impl.InterceptFieldTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.AbstractClassTransformerImpl;
import org.hibernate.bytecode.util.ClassFilter;
import org.hibernate.bytecode.util.FieldFilter;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.attrs.Attributes;

public class CglibClassTransformer
extends AbstractClassTransformerImpl {
    private static Log log = LogFactory.getLog((String)CglibClassTransformer.class.getName());

    public CglibClassTransformer(ClassFilter classFilter, FieldFilter fieldFilter) {
        super(classFilter, fieldFilter);
    }

    protected byte[] doTransform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        ClassReader reader;
        try {
            reader = new ClassReader((InputStream)new ByteArrayInputStream(classfileBuffer));
        }
        catch (IOException e) {
            log.error((Object)"Unable to read class", (Throwable)e);
            throw new HibernateException("Unable to read class: " + e.getMessage());
        }
        String[] names = ClassNameReader.getClassInfo((ClassReader)reader);
        DebuggingClassWriter w = new DebuggingClassWriter(true);
        ClassTransformer t = this.getClassTransformer(names);
        if (t != null) {
            byte[] result;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enhancing " + className));
            }
            try {
                reader = new ClassReader((InputStream)new ByteArrayInputStream(classfileBuffer));
                new TransformingClassGenerator((ClassGenerator)new ClassReaderGenerator(reader, this.attributes(), this.skipDebug()), t).generateClass((ClassVisitor)w);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(w.toByteArray());
                result = out.toByteArray();
                out.close();
            }
            catch (Exception e) {
                log.error((Object)"Unable to transform class", (Throwable)e);
                throw new HibernateException("Unable to transform class: " + e.getMessage());
            }
            return result;
        }
        return classfileBuffer;
    }

    private Attribute[] attributes() {
        return Attributes.getDefaultAttributes();
    }

    private boolean skipDebug() {
        return false;
    }

    private ClassTransformer getClassTransformer(final String[] classInfo) {
        if (this.isAlreadyInstrumented(classInfo)) {
            return null;
        }
        return new InterceptFieldTransformer(new InterceptFieldFilter(){

            public boolean acceptRead(Type owner, String name) {
                return CglibClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classInfo[0], owner.getClassName(), name);
            }

            public boolean acceptWrite(Type owner, String name) {
                return CglibClassTransformer.this.fieldFilter.shouldTransformFieldAccess(classInfo[0], owner.getClassName(), name);
            }
        });
    }

    private boolean isAlreadyInstrumented(String[] classInfo) {
        for (int i = 1; i < classInfo.length; ++i) {
            if (!InterceptFieldEnabled.class.getName().equals(classInfo[i])) continue;
            return true;
        }
        return false;
    }
}

