/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jms;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.jms.JMSBackendQueueProcessor;
import org.hibernate.search.engine.SearchFactoryImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSBackendQueueProcessorFactory
implements BackendQueueProcessorFactory {
    private String jmsQueueName;
    private String jmsConnectionFactoryName;
    private static final String JNDI_PREFIX = "hibernate.search.worker.jndi.";
    private Properties properties;
    private Queue jmsQueue;
    private QueueConnectionFactory factory;
    public static final String JMS_CONNECTION_FACTORY = "hibernate.search.worker.jms.connection_factory";
    public static final String JMS_QUEUE = "hibernate.search.worker.jms.queue";

    @Override
    public void initialize(Properties props, SearchFactoryImplementor searchFactoryImplementor) {
        this.properties = props;
        this.jmsConnectionFactoryName = props.getProperty(JMS_CONNECTION_FACTORY);
        this.jmsQueueName = props.getProperty(JMS_QUEUE);
        this.prepareJMSTools();
    }

    @Override
    public Runnable getProcessor(List<LuceneWork> queue) {
        return new JMSBackendQueueProcessor(queue, this);
    }

    public QueueConnectionFactory getJMSFactory() {
        return this.factory;
    }

    public Queue getJmsQueue() {
        return this.jmsQueue;
    }

    public String getJmsQueueName() {
        return this.jmsQueueName;
    }

    public void prepareJMSTools() {
        if (this.jmsQueue != null && this.factory != null) {
            return;
        }
        try {
            InitialContext initialContext = this.getInitialContext(this.properties);
            this.factory = (QueueConnectionFactory)initialContext.lookup(this.jmsConnectionFactoryName);
            this.jmsQueue = (Queue)initialContext.lookup(this.jmsQueueName);
        }
        catch (NamingException e) {
            throw new SearchException("Unable to lookup Search queue (" + (this.jmsQueueName != null ? this.jmsQueueName : "null") + ") and connection factory (" + (this.jmsConnectionFactoryName != null ? this.jmsConnectionFactoryName : "null") + ")", e);
        }
    }

    private InitialContext getInitialContext(Properties properties) throws NamingException {
        Properties jndiProps = JMSBackendQueueProcessorFactory.getJndiProperties(properties);
        if (jndiProps.size() == 0) {
            return new InitialContext();
        }
        return new InitialContext(jndiProps);
    }

    public static Properties getJndiProperties(Properties properties) {
        HashSet<String> specialProps = new HashSet<String>();
        specialProps.add("hibernate.search.worker.jndi.class");
        specialProps.add("hibernate.search.worker.jndi.url");
        Iterator<Object> iter = properties.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            String prop = (String)iter.next();
            if (prop.indexOf(JNDI_PREFIX) <= -1 || specialProps.contains(prop)) continue;
            result.setProperty(prop.substring(JNDI_PREFIX.length()), properties.getProperty(prop));
        }
        String jndiClass = properties.getProperty("hibernate.search.worker.jndi.class");
        String jndiURL = properties.getProperty("hibernate.search.worker.jndi.url");
        if (jndiClass != null) {
            result.put("java.naming.factory.initial", jndiClass);
        }
        if (jndiURL != null) {
            result.put("java.naming.provider.url", jndiURL);
        }
        return result;
    }
}

