/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.io.Serializable;
import java.util.Properties;
import org.apache.lucene.document.Document;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;

public class IdHashShardingStrategy
implements IndexShardingStrategy {
    private DirectoryProvider[] providers;

    public void initialize(Properties properties, DirectoryProvider[] providers) {
        this.providers = providers;
    }

    public DirectoryProvider[] getDirectoryProvidersForAllShards() {
        return this.providers;
    }

    public DirectoryProvider getDirectoryProviderForAddition(Class entity, Serializable id, String idInString, Document document) {
        return this.providers[this.hashKey(idInString)];
    }

    public DirectoryProvider[] getDirectoryProvidersForDeletion(Class entity, Serializable id, String idInString) {
        if (idInString == null) {
            return this.providers;
        }
        return new DirectoryProvider[]{this.providers[this.hashKey(idInString)]};
    }

    private int hashKey(String key) {
        int hash = 0;
        int length = key.length();
        for (int index = 0; index < length; ++index) {
            hash = 31 * hash + key.charAt(index);
        }
        return hash % this.providers.length;
    }
}

